/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.dcep;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import eu.play_project.play_platformservices.api.QueryDetails;
import eu.play_project.play_platformservices.api.QueryDispatchApi;
import eu.play_project.play_platformservices.jaxb.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SimplePatternService;
import org.ow2.play.governance.api.bean.Pattern;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class SimplePatternServiceImpl
implements SimplePatternService {
    private static Logger logger = Logger.getLogger(SimplePatternServiceImpl.class.getName());
    private Registry registry;

    public List<Topic> getInputTopics(String pattern) throws GovernanceExeption {
        ArrayList result = Lists.newArrayList();
        QueryDispatchApi dispatchClient = this.getQueryDispatchApiClient();
        if (dispatchClient != null) {
            QueryDetails details = dispatchClient.analyseQuery(this.generateID(), pattern);
            if (details != null) {
                List input = details.getInputStreams();
                result.addAll(Collections2.transform((Collection)input, (Function)new Function<String, Topic>(){

                    public Topic apply(String in) {
                        return SimplePatternServiceImpl.this.streamToTopic(in);
                    }
                }));
            } else {
                logger.warning("No details returned from the dispatcher");
            }
        } else {
            logger.warning("No dispatch client");
        }
        return result;
    }

    @WebMethod
    public List<Topic> getOutputTopics(String pattern) throws GovernanceExeption {
        ArrayList result = Lists.newArrayList();
        QueryDispatchApi dispatchClient = this.getQueryDispatchApiClient();
        if (dispatchClient != null) {
            QueryDetails details = dispatchClient.analyseQuery(this.generateID(), pattern);
            if (details != null) {
                String output = details.getOutputStream();
                result.add(this.streamToTopic(output));
            } else {
                logger.warning("No details returned from the dispatcher");
            }
        } else {
            logger.warning("No dispatch client found in the registry");
        }
        return result;
    }

    public String deploy(String id, String statement) throws GovernanceExeption {
        if (statement == null) {
            throw new GovernanceExeption("Can not deploy a null statement");
        }
        if (id == null) {
            id = this.generateID();
        }
        String result = null;
        try {
            result = this.getQueryDispatchApiClient().registerQuery(id, statement);
        }
        catch (Exception e) {
            throw new GovernanceExeption((Throwable)e);
        }
        return result;
    }

    public String undeploy(String id) throws GovernanceExeption {
        logger.info("Undeploying pattern " + id);
        try {
            this.getQueryDispatchApiClient().unregisterQuery(id);
        }
        catch (Exception e) {
            throw new GovernanceExeption("Can not undeploy pattern");
        }
        return "";
    }

    @WebMethod
    public List<Pattern> getPatterns() throws GovernanceExeption {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        List patterns = this.getQueryDispatchApiClient().getRegisteredQueries();
        if (patterns == null) {
            return result;
        }
        for (Query q : patterns) {
            Pattern pattern = new Pattern();
            pattern.id = q.id;
            pattern.content = q.content;
            pattern.name = q.name;
            pattern.recordDate = q.recordDate;
            result.add(pattern);
        }
        return result;
    }

    @WebMethod
    public Pattern getPattern(String id) throws GovernanceExeption {
        String pattern = this.getQueryDispatchApiClient().getRegisteredQuery(id);
        Pattern result = null;
        if (pattern != null) {
            result = new Pattern();
            result.content = pattern;
            result.id = id;
        }
        return result;
    }

    private QueryDispatchApi getQueryDispatchApiClient() throws GovernanceExeption {
        try {
            String url = this.registry.get("org.ow2.play.querydispatcher");
            if (url != null) {
                return (QueryDispatchApi)CXFHelper.getClientFromFinalURL((String)url, QueryDispatchApi.class);
            }
        }
        catch (RegistryException e) {
            throw new GovernanceExeption((Throwable)e);
        }
        return null;
    }

    protected Topic streamToTopic(String stream) {
        if (stream == null) {
            return null;
        }
        Topic topic = new Topic();
        Resource r = new Resource("stream", stream);
        String ns = r.getUrl().substring(0, r.getUrl().lastIndexOf(47) + 1);
        String name = r.getUrl().substring(r.getUrl().lastIndexOf(47) + 1);
        topic.setName(name);
        topic.setNs(ns);
        try {
            MetadataService client = this.getMetadataClient(this.registry.get("org.ow2.play.metadata"));
            Metadata md = client.getMetadataValue(r, "http://www.play-project.eu/xml/ns/topic/prefix");
            if (md != null && md.getData() != null && md.getData().size() == 1 && ((Data)md.getData().get(0)).getValue() != null) {
                topic.setPrefix(((Data)md.getData().get(0)).getValue());
            } else {
                topic.setPrefix("s");
            }
        }
        catch (Exception e) {
            String msg = "Can not get registry endpoint";
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Can not get registry endpoint", e);
            } else {
                logger.warning("Can not get registry endpoint");
            }
            topic.setPrefix("s");
        }
        return topic;
    }

    protected String generateID() {
        return "http://play.ow2.org/pattern/" + UUID.randomUUID().toString();
    }

    protected MetadataService getMetadataClient(String endpoint) {
        return (MetadataService)CXFHelper.getClientFromFinalURL((String)endpoint, MetadataService.class);
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

