/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.ec;

import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsApi;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.play.governance.api.EventCloudsManagementWs;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class EventCloudsManagementWsImpl
implements EventCloudsManagementWs {
    private Registry registry;
    private static Logger logger = Logger.getLogger(EventCloudsManagementWsImpl.class.getName());

    public String getRegistryEndpointUrl() throws GovernanceExeption {
        logger.info("getRegistryEndpointUrl");
        return this.getCloudManagementServiceApi().getRegistryEndpointUrl();
    }

    public boolean createEventCloud(String streamUrl) throws GovernanceExeption {
        logger.info("Create Event Cloud " + streamUrl);
        return this.getCloudManagementServiceApi().createEventCloud(streamUrl);
    }

    public boolean isCreated(String streamUrl) throws GovernanceExeption {
        logger.info("Is Created Event Cloud " + streamUrl);
        return this.getCloudManagementServiceApi().isCreated(streamUrl);
    }

    public List<String> getEventCloudIds() throws GovernanceExeption {
        logger.info("getEventCloudIds");
        return this.getCloudManagementServiceApi().getEventCloudIds();
    }

    public boolean destroyEventCloud(String streamUrl) throws GovernanceExeption {
        logger.info("Destroy Event Cloud " + streamUrl);
        return this.getCloudManagementServiceApi().destroyEventCloud(streamUrl);
    }

    public String deployPublishWsnService(String streamUrl) throws GovernanceExeption {
        logger.info("Deploy Publish WSN Service " + streamUrl);
        return this.getCloudManagementServiceApi().deployPublishWsnService(streamUrl);
    }

    public String deploySubscribeWsnService(String streamUrl) throws GovernanceExeption {
        logger.info("Deploy Subscribe WSN Service " + streamUrl);
        return this.getCloudManagementServiceApi().deploySubscribeWsnService(streamUrl);
    }

    public String deployPublishWsProxy(String streamUrl) throws GovernanceExeption {
        logger.info("Deploy Publish WS Proxy " + streamUrl);
        return this.getCloudManagementServiceApi().deployPublishWsProxy(streamUrl);
    }

    public String deploySubscribeWsProxy(String streamUrl) throws GovernanceExeption {
        logger.info("Deploy Subscribe WS Proxy " + streamUrl);
        return this.getCloudManagementServiceApi().deploySubscribeWsProxy(streamUrl);
    }

    public String deployPutGetWsProxy(String streamUrl) throws GovernanceExeption {
        logger.info("Deploy Put/Get Proxy " + streamUrl);
        return this.getCloudManagementServiceApi().deployPutGetWsProxy(streamUrl);
    }

    public List<String> getPublishWsnServiceEndpointUrls(String streamUrl) throws GovernanceExeption {
        logger.info("Get Publish WSN Service endpoints " + streamUrl);
        return this.getCloudManagementServiceApi().getPublishWsnServiceEndpointUrls(streamUrl);
    }

    public List<String> getSubscribeWsnServiceEndpointUrls(String streamUrl) throws GovernanceExeption {
        logger.info("Get Subscribe WSN Service endpoints " + streamUrl);
        return this.getCloudManagementServiceApi().getSubscribeWsnServiceEndpointUrls(streamUrl);
    }

    public List<String> getPublishWsProxyEndpointUrls(String streamUrl) throws GovernanceExeption {
        logger.info("Get Publish WS Proxy endpoints " + streamUrl);
        return this.getCloudManagementServiceApi().getPublishWsProxyEndpointUrls(streamUrl);
    }

    public List<String> getSubscribeWsProxyEndpointUrls(String streamUrl) throws GovernanceExeption {
        logger.info("Get Subscribe WS Proxy endpoints " + streamUrl);
        return this.getCloudManagementServiceApi().getSubscribeWsProxyEndpointUrls(streamUrl);
    }

    public List<String> getPutGetWsProxyEndpointUrls(String streamUrl) throws GovernanceExeption {
        logger.info("Get Put/Get Proxy endpoints " + streamUrl);
        return this.getCloudManagementServiceApi().getPutGetWsProxyEndpointUrls(streamUrl);
    }

    public boolean destroyPublishWsnService(String publishWsnEndpointUrl) throws GovernanceExeption {
        logger.info("Destroy Publish WSN Service " + publishWsnEndpointUrl);
        return this.getCloudManagementServiceApi().destroyPublishWsnService(publishWsnEndpointUrl);
    }

    public boolean destroySubscribeWsnService(String subscribeWsnEndpointUrl) throws GovernanceExeption {
        logger.info("Destroy Subscribe WSN Service " + subscribeWsnEndpointUrl);
        return this.getCloudManagementServiceApi().destroySubscribeWsnService(subscribeWsnEndpointUrl);
    }

    public boolean destroyPublishWsProxy(String publishWsProxyEndpointUrl) throws GovernanceExeption {
        logger.info("Destroy Publish WS Proxy " + publishWsProxyEndpointUrl);
        return this.getCloudManagementServiceApi().destroyPublishWsProxy(publishWsProxyEndpointUrl);
    }

    public boolean destroySubscribeWsProxy(String subscribeWsProxyEndpointUrl) throws GovernanceExeption {
        logger.info("Destroy Subscribe WS Proxy " + subscribeWsProxyEndpointUrl);
        return this.getCloudManagementServiceApi().destroySubscribeWsProxy(subscribeWsProxyEndpointUrl);
    }

    public boolean destroyPutGetWsProxy(String putgetWsProxyEndpointUrl) throws GovernanceExeption {
        logger.info("Destroy Put/Get WS Proxy " + putgetWsProxyEndpointUrl);
        return this.getCloudManagementServiceApi().destroyPutGetWsProxy(putgetWsProxyEndpointUrl);
    }

    public EventCloudsManagementWsApi getCloudManagementServiceApi() throws GovernanceExeption {
        try {
            return (EventCloudsManagementWsApi)CXFHelper.getClientFromFinalURL((String)this.registry.get("org.ow2.play.dsb2ec.eventcloud"), EventCloudsManagementWsApi.class);
        }
        catch (RegistryException e) {
            throw new GovernanceExeption(e.getMessage());
        }
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

