/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.migrator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SubscriptionRegistry;
import org.ow2.play.governance.api.bean.Subscription;
import org.petalslink.dsb.cxf.CXFHelper;

public class SubscriptionRegistryV1ToV1 {
    private static final Logger logger = Logger.getLogger(SubscriptionRegistryV1ToV1.class.getName());

    public static List<Subscription> migrate(String source, String destination) throws GovernanceExeption {
        if (source == null || destination == null) {
            throw new GovernanceExeption("Source and destination must be filled");
        }
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        SubscriptionRegistry sourceRegistry = (SubscriptionRegistry)CXFHelper.getClientFromFinalURL((String)source, SubscriptionRegistry.class);
        SubscriptionRegistry destinationRegistry = (SubscriptionRegistry)CXFHelper.getClientFromFinalURL((String)destination, SubscriptionRegistry.class);
        List sources = sourceRegistry.getSubscriptions();
        if (sources != null) {
            for (Subscription subscription : sources) {
                try {
                    destinationRegistry.addSubscription(subscription);
                    result.add(subscription);
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.info("Added subscription = " + subscription);
                }
                catch (Exception e) {
                    logger.warning("Can not add the subscription to destination : " + subscription);
                }
            }
        }
        return result;
    }
}

