/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.storage;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.ow2.play.governance.api.bean.Pattern;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.api.bean.Topic;

public class Helper {
    public static final String ID_KEY = "id";
    public static final String SUBSCRIBER_KEY = "subscriber";
    public static final String PRODUCER_KEY = "producer";
    public static final String TOPIC_KEY = "topic";
    public static final String DATE_KEY = "date";
    public static final String STATUS_KEY = "status";
    public static final String TOPIC_NAME_KEY = "name";
    public static final String TOPIC_NS_KEY = "ns";
    public static final String TOPIC_PREFIX_KEY = "prefix";
    public static final String CONTENT_KEY = "content";
    public static final String NAME_KEY = "name";

    private Helper() {
    }

    protected static final DBObject toDBO(Subscription subscription) {
        if (subscription == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(ID_KEY, (Object)subscription.getId());
        dbo.put(PRODUCER_KEY, (Object)subscription.getProvider());
        dbo.put(SUBSCRIBER_KEY, (Object)subscription.getSubscriber());
        dbo.put(DATE_KEY, (Object)Long.toString(subscription.getDate()));
        dbo.put(STATUS_KEY, (Object)subscription.getStatus());
        if (subscription.getTopic() != null) {
            BasicDBObject topic = new BasicDBObject();
            topic.put("name", (Object)subscription.getTopic().getName());
            topic.put(TOPIC_NS_KEY, (Object)subscription.getTopic().getNs());
            topic.put(TOPIC_PREFIX_KEY, (Object)subscription.getTopic().getPrefix());
            dbo.put(TOPIC_KEY, (Object)topic);
        }
        return dbo;
    }

    protected static final Subscription toSubscription(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        Subscription s = new Subscription();
        s.setId(dbo.get(ID_KEY) == null ? "" : dbo.get(ID_KEY).toString());
        s.setSubscriber(dbo.get(SUBSCRIBER_KEY) == null ? "" : dbo.get(SUBSCRIBER_KEY).toString());
        s.setProvider(dbo.get(PRODUCER_KEY) == null ? "" : dbo.get(PRODUCER_KEY).toString());
        s.setDate(dbo.get(DATE_KEY) == null ? 0L : Long.parseLong(dbo.get(DATE_KEY).toString()));
        s.setStatus(dbo.get(STATUS_KEY) == null ? "" : dbo.get(STATUS_KEY).toString());
        if (dbo.get(TOPIC_KEY) != null && dbo.get(TOPIC_KEY) instanceof DBObject) {
            DBObject to = (DBObject)dbo.get(TOPIC_KEY);
            Topic t = new Topic();
            t.setName(to.get("name") == null ? "" : to.get("name").toString());
            t.setNs(to.get(TOPIC_NS_KEY) == null ? "" : to.get(TOPIC_NS_KEY).toString());
            t.setPrefix(to.get(TOPIC_PREFIX_KEY) == null ? "" : to.get(TOPIC_PREFIX_KEY).toString());
            s.setTopic(t);
        }
        return s;
    }

    protected static final DBObject toDBO(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(ID_KEY, (Object)pattern.id);
        dbo.put("name", (Object)pattern.name);
        dbo.put(CONTENT_KEY, (Object)pattern.content);
        dbo.put(DATE_KEY, (Object)(pattern.recordDate == null ? "" + System.currentTimeMillis() : pattern.recordDate));
        return dbo;
    }

    protected static final Pattern toPattern(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        Pattern p = new Pattern();
        p.id = dbo.get(ID_KEY) == null ? "" : dbo.get(ID_KEY).toString();
        p.content = dbo.get(CONTENT_KEY) == null ? "" : dbo.get(CONTENT_KEY).toString();
        p.name = dbo.get("name") == null ? "" : dbo.get("name").toString();
        p.recordDate = dbo.get(DATE_KEY) == null ? "" : dbo.get(DATE_KEY).toString();
        return p;
    }
}

