/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.storage;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.ow2.petals.nosql.mongo.AbstractMongoService;
import org.ow2.play.governance.api.BootSubscriptionService;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.storage.Helper;
import org.ow2.play.governance.storage.MongoSubscriptionRegistry;

@WebService
public class MongoBootSubscriptionService
extends AbstractMongoService
implements BootSubscriptionService {
    private static Logger logger = Logger.getLogger(MongoSubscriptionRegistry.class.getName());

    public MongoBootSubscriptionService() {
        this.setCollectionName("bootsubscriptions");
        this.setDatabaseName("play");
    }

    @WebMethod(exclude=true)
    public void init() {
        this.initializeMongo();
    }

    @WebMethod
    public void add(Subscription subscription) throws GovernanceExeption {
        if (subscription == null) {
            throw new GovernanceExeption("Null subscriptions can not be added");
        }
        DBObject dbo = Helper.toDBO(subscription);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding subscription object to collection : " + dbo);
        }
        this.getDbCollection().insert(new DBObject[]{dbo});
    }

    public void remove(Subscription subscription) throws GovernanceExeption {
        if (subscription == null) {
            throw new GovernanceExeption("Can not remove null subscriptions");
        }
        throw new GovernanceExeption("Remove is not implemented");
    }

    @WebMethod
    public void removeAll() {
        this.clearCollection();
    }

    @WebMethod
    public void load(String url) throws GovernanceExeption {
    }

    @WebMethod
    public List<Subscription> all() throws GovernanceExeption {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting subscritions");
        }
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        DBCursor cursor = this.getDbCollection().find();
        for (DBObject dbo : cursor) {
            Subscription s;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extracting subscription : " + dbo);
            }
            if ((s = Helper.toSubscription(dbo)) == null) continue;
            result.add(s);
        }
        return result;
    }
}

