/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.storage;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.petals.nosql.mongo.AbstractMongoService;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.PatternRegistry;
import org.ow2.play.governance.api.bean.Pattern;
import org.ow2.play.governance.storage.Helper;

public class MongoPatternRegistry
extends AbstractMongoService
implements PatternRegistry {
    private static final Logger logger = Logger.getLogger(MongoPatternRegistry.class.getName());

    public MongoPatternRegistry() {
        this.setCollectionName("patterns");
        this.setDatabaseName("play");
    }

    @WebMethod(exclude=true)
    public void init() {
        this.initializeMongo();
    }

    public void put(Pattern pattern) throws GovernanceExeption {
        if (pattern == null) {
            throw new GovernanceExeption("Null pattern can not be added");
        }
        if (pattern.recordDate == null) {
            pattern.recordDate = System.currentTimeMillis() + "";
        }
        DBObject dbo = Helper.toDBO(pattern);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding pattern object to collection : " + dbo);
        }
        this.getDbCollection().insert(new DBObject[]{dbo});
    }

    public void delete(List<String> ids) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    public void clear() throws GovernanceExeption {
        logger.info("Removing all the patterns");
        this.clearCollection();
    }

    public Pattern get(String id) throws GovernanceExeption {
        Pattern p = null;
        BasicDBObject query = new BasicDBObject();
        query.put("id", (Object)id);
        DBObject result = this.getCollection().findOne((DBObject)query);
        if (result != null) {
            p = Helper.toPattern(result);
        }
        return p;
    }

    public List<Pattern> all() throws GovernanceExeption {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        DBCursor cursor = this.getDbCollection().find();
        for (DBObject dbo : cursor) {
            Pattern s;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extracting Pattern : " + dbo);
            }
            if ((s = Helper.toPattern(dbo)) == null) continue;
            result.add(s);
        }
        return result;
    }
}

