/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.storage;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import org.ow2.play.governance.api.SubscriptionRegistry;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.api.bean.Topic;

public class MongoSubscriptionRegistry
implements SubscriptionRegistry {
    private static final String DEFAULT_MONGO_DB_HOSTNAME = "localhost";
    private static final String DEFAULT_MONGO_DB_PORT = "27017";
    private static final String DEFAULT_MONGO_DB_DATABASE_NAME = "play";
    private static final String DEFAULT_MONGO_DB_COLLECTION_NAME = "subscription";
    private static final String ID_KEY = "id";
    private static final String SUBSCRIBER_KEY = "subscriber";
    private static final String PRODUCER_KEY = "producer";
    private static final String TOPIC_KEY = "topic";
    private static final String DATE_KEY = "date";
    private static final String STATUS_KEY = "status";
    private static final String TOPIC_NAME_KEY = "name";
    private static final String TOPIC_NS_KEY = "ns";
    private static final String TOPIC_PREFIX_KEY = "prefix";
    private String hostname = "localhost";
    private String port = "27017";
    private String databaseName = "play";
    private String collectionName = "subscription";
    private String userName;
    private String password;
    private Mongo mongo;
    private DBCollection collection;
    private Properties properties;
    private boolean initialized = false;
    private static Logger logger = Logger.getLogger(MongoSubscriptionRegistry.class.getName());

    @WebMethod(exclude=true)
    public void init() {
        logger.info("Initializing metadata service");
        if (this.mongo != null) {
            this.close();
        }
        if (this.properties != null) {
            this.hostname = this.properties.getProperty("mongo.hostname", DEFAULT_MONGO_DB_HOSTNAME);
            this.port = this.properties.getProperty("mongo.port", DEFAULT_MONGO_DB_PORT);
            this.userName = this.properties.getProperty("mongo.username", this.userName);
            this.password = this.properties.getProperty("mongo.password", this.password);
            this.collectionName = this.properties.getProperty("mongo.collection", DEFAULT_MONGO_DB_COLLECTION_NAME);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Connection to %s %s with credentials %s %s", this.hostname, this.port, this.userName, "******"));
        }
        List<ServerAddress> addresses = this.getServerAddresses(this.hostname, this.port);
        this.mongo = this.getMongo(addresses);
        DB database = this.getDatabase(this.mongo, this.databaseName);
        if (this.userName != null && this.userName.trim().length() > 0) {
            if (!database.authenticate(this.userName, this.password.toCharArray())) {
                throw new RuntimeException("Unable to authenticate with MongoDB server.");
            }
            this.password = null;
        }
        this.setCollection(database.getCollection(this.collectionName));
        this.initialized = true;
    }

    protected void clearCollection() {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Going to clear collection : " + this.collectionName);
        }
        if (this.initialized) {
            WriteResult wr = this.getDbCollection().remove((DBObject)new BasicDBObject());
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Clear collection result :" + wr);
            }
        }
    }

    protected DB getDatabase(Mongo mongo, String databaseName) {
        return mongo.getDB(databaseName);
    }

    protected DBCollection getDbCollection() {
        return this.collection;
    }

    protected Mongo getMongo(List<ServerAddress> addresses) {
        if (addresses.size() == 1) {
            return new Mongo(addresses.get(0));
        }
        return new Mongo(addresses);
    }

    protected void close() {
        if (this.mongo != null) {
            this.collection = null;
            this.mongo.close();
        }
    }

    public void setCollection(DBCollection collection) {
        assert (collection != null) : "collection must not be null";
        this.collection = collection;
    }

    private List<ServerAddress> getServerAddresses(String hostname, String port) {
        List<Integer> portNums;
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        String[] hosts = hostname.split(" ");
        String[] ports = port.split(" ");
        if (!(ports.length != 1 && ports.length != hosts.length || (portNums = this.getPortNums(ports)).size() != 1 && portNums.size() != hosts.length)) {
            boolean onePort = portNums.size() == 1;
            int i = 0;
            for (String host : hosts) {
                int portNum = onePort ? portNums.get(0) : portNums.get(i);
                try {
                    addresses.add(new ServerAddress(host.trim(), portNum));
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return addresses;
    }

    private List<Integer> getPortNums(String[] ports) {
        ArrayList<Integer> portNums = new ArrayList<Integer>();
        for (String port : ports) {
            try {
                Integer portNum = Integer.valueOf(port.trim());
                if (portNum < 0) continue;
                portNums.add(portNum);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return portNums;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @WebMethod
    public void addSubscription(Subscription subscription) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding subscription : " + subscription);
        }
        if (subscription == null) {
            logger.warning("Can not add null subscription");
            return;
        }
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(ID_KEY, (Object)subscription.getId());
        dbo.put(PRODUCER_KEY, (Object)subscription.getProvider());
        dbo.put(SUBSCRIBER_KEY, (Object)subscription.getSubscriber());
        dbo.put(DATE_KEY, (Object)Long.toString(subscription.getDate()));
        dbo.put(STATUS_KEY, (Object)subscription.getStatus());
        if (subscription.getTopic() != null) {
            BasicDBObject topic = new BasicDBObject();
            topic.put(TOPIC_NAME_KEY, (Object)subscription.getTopic().getName());
            topic.put(TOPIC_NS_KEY, (Object)subscription.getTopic().getNs());
            topic.put(TOPIC_PREFIX_KEY, (Object)subscription.getTopic().getPrefix());
            dbo.put(TOPIC_KEY, (Object)topic);
        } else {
            logger.warning("No topic set in the subscription, added to collection without it...");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding subscription object to collection : " + dbo);
        }
        this.getDbCollection().insert(new DBObject[]{dbo});
    }

    @WebMethod
    public List<Subscription> getSubscriptions() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting subscritions");
        }
        DBCursor cursor = this.getDbCollection().find();
        Iterator iter = cursor.iterator();
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        while (iter.hasNext()) {
            Subscription s;
            DBObject dbo = (DBObject)iter.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extracting subscription : " + dbo);
            }
            if ((s = this.toSubscription(dbo)) == null) continue;
            result.add(this.toSubscription(dbo));
        }
        return result;
    }

    @WebMethod
    public List<Subscription> getSubscriptions(@WebParam(name="filter") Subscription filter) {
        ArrayList<Subscription> result = null;
        if (filter == null) {
            return this.getSubscriptions();
        }
        result = new ArrayList<Subscription>();
        BasicDBObject f = new BasicDBObject();
        if (filter.getDate() >= 0L) {
            f.put(DATE_KEY, (Object)Long.toString(filter.getDate()));
        }
        if (filter.getId() != null) {
            f.put(ID_KEY, (Object)filter.getId());
        }
        if (filter.getProvider() != null) {
            f.put(PRODUCER_KEY, (Object)filter.getProvider());
        }
        if (filter.getSubscriber() != null) {
            f.put(SUBSCRIBER_KEY, (Object)filter.getSubscriber());
        }
        if (filter.getStatus() != null) {
            f.put(STATUS_KEY, (Object)filter.getStatus());
        }
        if (filter.getTopic() != null) {
            if (filter.getTopic().getName() != null) {
                f.put("topic.name", (Object)filter.getTopic().getName());
            }
            if (filter.getTopic().getNs() != null) {
                f.put("topic.ns", (Object)filter.getTopic().getNs());
            }
            if (filter.getTopic().getPrefix() != null) {
                f.put("topic.prefix", (Object)filter.getTopic().getNs());
            }
        }
        logger.fine("Filtering with : " + f);
        DBCursor cursor = this.getDbCollection().find((DBObject)f);
        for (DBObject dbo : cursor) {
            Subscription s;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extracting subscription : " + dbo);
            }
            if ((s = this.toSubscription(dbo)) == null) continue;
            result.add(this.toSubscription(dbo));
        }
        return result;
    }

    @WebMethod
    public List<Subscription> removeAll() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove all the subscriptions from the collection");
        }
        WriteResult wr = this.getDbCollection().remove((DBObject)new BasicDBObject());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Write result : " + wr);
        }
        return new ArrayList<Subscription>();
    }

    @WebMethod
    public boolean remove(Subscription subscription) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing subscription : " + subscription);
        }
        if (subscription == null || subscription.getId() == null) {
            return false;
        }
        BasicDBObject filter = new BasicDBObject();
        filter.put(ID_KEY, (Object)subscription.getId());
        WriteResult wr = this.getDbCollection().remove((DBObject)filter);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove result : " + wr);
        }
        return true;
    }

    @WebMethod
    public List<Subscription> removeAllFromProvider(String provider) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove subscriptions from provider : " + provider);
        }
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        if (provider == null) {
            return result;
        }
        BasicDBObject filter = new BasicDBObject();
        filter.put(PRODUCER_KEY, (Object)provider);
        WriteResult wr = this.getDbCollection().remove((DBObject)filter);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove result : " + wr);
        }
        return result;
    }

    @WebMethod
    public List<Subscription> removeAllFromConsumer(String consumer) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove all from consumer : " + consumer);
        }
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        if (consumer == null) {
            return result;
        }
        BasicDBObject filter = new BasicDBObject();
        filter.put(SUBSCRIBER_KEY, (Object)consumer);
        WriteResult wr = this.getDbCollection().remove((DBObject)filter);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove result : " + wr);
        }
        return result;
    }

    protected Subscription toSubscription(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        Subscription s = new Subscription();
        s.setId(dbo.get(ID_KEY) == null ? "" : dbo.get(ID_KEY).toString());
        s.setSubscriber(dbo.get(SUBSCRIBER_KEY) == null ? "" : dbo.get(SUBSCRIBER_KEY).toString());
        s.setProvider(dbo.get(PRODUCER_KEY) == null ? "" : dbo.get(PRODUCER_KEY).toString());
        s.setDate(dbo.get(DATE_KEY) == null ? 0L : Long.parseLong(dbo.get(DATE_KEY).toString()));
        s.setStatus(dbo.get(STATUS_KEY) == null ? "" : dbo.get(STATUS_KEY).toString());
        if (dbo.get(TOPIC_KEY) != null && dbo.get(TOPIC_KEY) instanceof DBObject) {
            DBObject to = (DBObject)dbo.get(TOPIC_KEY);
            Topic t = new Topic();
            t.setName(to.get(TOPIC_NAME_KEY) == null ? "" : to.get(TOPIC_NAME_KEY).toString());
            t.setNs(to.get(TOPIC_NS_KEY) == null ? "" : to.get(TOPIC_NS_KEY).toString());
            t.setPrefix(to.get(TOPIC_PREFIX_KEY) == null ? "" : to.get(TOPIC_PREFIX_KEY).toString());
            s.setTopic(t);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Topic is null");
        }
        return s;
    }
}

