/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.bootstrap;

import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsApi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.play.commons.utils.StreamHelper;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SubscriptionRegistry;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.governance.bootstrap.MemoryLogServiceImpl;
import org.ow2.play.governance.bootstrap.api.BootstrapFault;
import org.ow2.play.governance.bootstrap.api.BootstrapService;
import org.ow2.play.governance.bootstrap.api.EventCloudClientFactory;
import org.ow2.play.governance.bootstrap.api.GovernanceClient;
import org.ow2.play.governance.bootstrap.api.LogService;
import org.ow2.play.governance.bootstrap.api.TopicManager;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;

public class DSBSubscribesToECBootstrapServiceImpl
implements BootstrapService {
    private static Logger logger = Logger.getLogger(DSBSubscribesToECBootstrapServiceImpl.class.getName());
    private TopicManager topicManager;
    private EventCloudClientFactory eventCloudClientFactory;
    private GovernanceClient governanceClient;
    private SubscriptionRegistry subscriptionRegistry;
    private MetadataService metadataServiceClient;

    public List<Subscription> bootstrap(String eventCloudEndpoint, String subscriberEndpoint) throws BootstrapFault {
        List topics;
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        if (eventCloudEndpoint == null) {
            throw new BootstrapFault("Can not find any EventCloud endpoint, please check the settings");
        }
        if (subscriberEndpoint == null) {
            throw new BootstrapFault("Can not find any subscriber endpoint, please check the settings");
        }
        try {
            topics = this.governanceClient.getTopics();
        }
        catch (GovernanceExeption e) {
            throw new BootstrapFault("Can not get topics", (Throwable)e);
        }
        if (topics == null || topics.size() == 0) {
            throw new BootstrapFault("Can not get any topic from the governance");
        }
        for (Topic topic : topics) {
            try {
                Subscription subscription = this.createResources(topic, eventCloudEndpoint, subscriberEndpoint);
                if (subscription == null) continue;
                result.add(subscription);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected Subscription createResources(Topic topic, String eventCloudEndpoint, String subscriberEndpoint) throws BootstrapFault {
        Subscription result = null;
        LogService log = MemoryLogServiceImpl.get();
        QName topicName = new QName(topic.getNs(), topic.getName(), topic.getPrefix());
        logger.info("Let's do it for topic " + topic);
        EventCloudsManagementWsApi client = this.eventCloudClientFactory.getClient(eventCloudEndpoint);
        String streamName = StreamHelper.getStreamName((QName)topicName);
        boolean created = client.createEventCloud(streamName);
        if (created) {
            client.deploySubscribeWsnService(streamName);
            client.deployPublishWsnService(streamName);
            client.deploySubscribeWsProxy(streamName);
            client.deployPublishWsProxy(streamName);
            client.deployPutGetWsProxy(streamName);
            log.log("EventCloud has been created for stream %s", new Object[]{streamName});
        } else {
            log.log("EventCloud has been already created for stream %s", new Object[]{streamName});
        }
        if (this.needsToSubscribe(streamName)) {
            if (this.alreadySubscribed(topic, eventCloudEndpoint, subscriberEndpoint)) {
                log.log("DSB already subscribed to EC for topic %s", new Object[]{topic});
                logger.info(String.format("Already subscribed to topic %s", topic));
                return result;
            }
            List endpoints = client.getSubscribeWsnServiceEndpointUrls(streamName);
            if (endpoints == null || endpoints.size() == 0) {
                log.log("Can not find any subscribe endpoint in the EC for stream %s", new Object[]{streamName});
            } else {
                log.log("Let's subscribe to eventcloud for stream %s", new Object[]{streamName});
                result = this.topicManager.subscribe((String)endpoints.get(0), topicName, subscriberEndpoint);
                log.log("DSB subscribed to EC : " + result);
            }
        } else {
            log.log("Do not need to subscribe to eventcloud for stream %s", new Object[]{streamName});
        }
        return result;
    }

    protected boolean alreadySubscribed(Topic topic, String eventCloudEndpoint, String subscriberEndpoint) {
        List subscriptions = null;
        try {
            subscriptions = this.subscriptionRegistry.getSubscriptions();
        }
        catch (GovernanceExeption e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Got an error while getting subscriptions", e);
            } else {
                logger.warning("Got an error while getting subscriptions");
            }
            return false;
        }
        if (subscriptions == null) {
            return false;
        }
        Iterator iter = subscriptions.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Subscription subscription = (Subscription)iter.next();
            found = subscription.getTopic().equals((Object)topic) && subscription.getSubscriber().equals(subscriberEndpoint);
        }
        return found;
    }

    protected boolean needsToSubscribe(String stream) {
        if (stream == null) {
            return false;
        }
        Resource r = new Resource("stream", stream);
        Metadata metadata = null;
        try {
            metadata = this.metadataServiceClient.getMetadataValue(r, "http://www.play-project.eu/xml/ns/dsbneedstosubscribe");
        }
        catch (MetadataException e) {
            return false;
        }
        return metadata != null && metadata.getData().contains(new Data("literal", "true"));
    }

    public void setTopicManager(TopicManager topicManager) {
        this.topicManager = topicManager;
    }

    public void setEventCloudClientFactory(EventCloudClientFactory eventCloudClientFactory) {
        this.eventCloudClientFactory = eventCloudClientFactory;
    }

    public void setGovernanceClient(GovernanceClient governanceClient) {
        this.governanceClient = governanceClient;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public void setMetadataServiceClient(MetadataService metadataServiceClient) {
        this.metadataServiceClient = metadataServiceClient;
    }
}

