/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.bootstrap;

import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsApi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.play.commons.utils.StreamHelper;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SubscriptionRegistry;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.governance.bootstrap.MemoryLogServiceImpl;
import org.ow2.play.governance.bootstrap.api.BootstrapFault;
import org.ow2.play.governance.bootstrap.api.BootstrapService;
import org.ow2.play.governance.bootstrap.api.EventCloudClientFactory;
import org.ow2.play.governance.bootstrap.api.GovernanceClient;
import org.ow2.play.governance.bootstrap.api.LogService;
import org.ow2.play.governance.bootstrap.api.TopicManager;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;

public class ECSubscribesToDSBBootstrapServiceImpl
implements BootstrapService {
    private static Logger logger = Logger.getLogger(ECSubscribesToDSBBootstrapServiceImpl.class.getName());
    private TopicManager topicManager;
    private EventCloudClientFactory eventCloudClientFactory;
    private GovernanceClient governanceClient;
    private SubscriptionRegistry subscriptionRegistry;
    private MetadataService metadataServiceClient;

    public List<Subscription> bootstrap(String providerEndpoint, String subscriberEndpoint) throws BootstrapFault {
        List topics;
        logger.info("Init all EC subscribes to DSB");
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        try {
            topics = this.governanceClient.getTopics();
        }
        catch (Exception e) {
            throw new BootstrapFault((Throwable)e);
        }
        if (topics == null || topics.size() == 0) {
            throw new BootstrapFault("Can not get any topic");
        }
        for (Topic topic : topics) {
            logger.info("Create stuff for topic " + topic);
            Subscription bean = this.createResources(topic, providerEndpoint, subscriberEndpoint);
            if (bean == null) continue;
            result.add(bean);
        }
        return result;
    }

    private Subscription createResources(Topic topic, String providerEndpoint, String subscriberEndpoint) {
        String subscriber;
        LogService log = MemoryLogServiceImpl.get();
        Subscription result = null;
        EventCloudsManagementWsApi client = this.eventCloudClientFactory.getClient(subscriberEndpoint);
        QName topicName = new QName(topic.getNs(), topic.getName(), topic.getPrefix());
        String stream = StreamHelper.getStreamName((QName)topicName);
        List publishURLs = client.getPublishWsnServiceEndpointUrls(stream);
        logger.info("Got some URLs back from the EC : " + publishURLs);
        String string = subscriber = publishURLs != null && publishURLs.size() > 0 ? (String)publishURLs.get(0) : null;
        if (subscriber == null) {
            log.log("Can not find any valid endpoint from EC for stream %s", new Object[]{stream});
            logger.info("Can not get any valid EC endpoint");
            return null;
        }
        logger.info("Let's use the EC endpoint at : " + subscriber);
        if (this.alreadySubscribed(topic, subscriber, providerEndpoint)) {
            log.log("EC already subscribed to DSB for topic %s", new Object[]{topic});
            logger.info(String.format("EC at %s already subscribed to topic %s", topic));
            return result;
        }
        if (this.needsToSubscribe(stream)) {
            try {
                logger.info("Subscribe for topic " + topic);
                result = this.topicManager.subscribe(providerEndpoint, topicName, subscriber);
                log.log("EC subscribed to DSB : " + result);
            }
            catch (BootstrapFault e) {
                e.printStackTrace();
            }
        } else {
            log.log("Do not need to subscribe EC->DSB for stream %s", new Object[]{stream});
            logger.info("No need to subscribe EC->DSB for the topic " + topic);
        }
        return result;
    }

    protected boolean needsToSubscribe(String stream) {
        if (stream == null) {
            return false;
        }
        Resource r = new Resource("stream", stream);
        Metadata metadata = null;
        try {
            metadata = this.metadataServiceClient.getMetadataValue(r, "http://www.play-project.eu/xml/ns/dsbneedstosubscribe");
        }
        catch (MetadataException e) {
            return false;
        }
        return metadata == null || metadata.getData().contains(new Data("literal", "false"));
    }

    protected boolean alreadySubscribed(Topic topic, String eventCloudEndpoint, String dsbEndpoint) {
        List subscriptions;
        try {
            subscriptions = this.subscriptionRegistry.getSubscriptions();
        }
        catch (GovernanceExeption e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Got an error while getting subscriptions", e);
            } else {
                logger.warning("Got an error while getting subscriptions");
            }
            return false;
        }
        if (subscriptions == null) {
            return false;
        }
        Iterator iter = subscriptions.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Subscription subscription = (Subscription)iter.next();
            found = subscription.getTopic().equals((Object)topic) && subscription.getSubscriber().equals(eventCloudEndpoint);
        }
        return found;
    }

    public void setTopicManager(TopicManager topicManager) {
        this.topicManager = topicManager;
    }

    public void setEventCloudClientFactory(EventCloudClientFactory eventCloudClientFactory) {
        this.eventCloudClientFactory = eventCloudClientFactory;
    }

    public void setGovernanceClient(GovernanceClient governanceClient) {
        this.governanceClient = governanceClient;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public void setMetadataServiceClient(MetadataService metadataServiceClient) {
        this.metadataServiceClient = metadataServiceClient;
    }
}

