/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.bootstrap.client;

import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class MetadataServiceClient
implements MetadataService {
    private MetadataService client;
    private Registry registry;
    private static Logger logger = Logger.getLogger(MetadataServiceClient.class.getName());

    protected synchronized MetadataService getClient() throws MetadataException {
        if (this.client == null) {
            if (this.registry == null) {
                logger.warning("Can not get the registry!");
                throw new MetadataException("Can not get the registry");
            }
            String url = null;
            try {
                url = this.registry.get("org.ow2.play.metadata");
            }
            catch (RegistryException e) {
                throw new MetadataException((Throwable)e);
            }
            if (url == null) {
                logger.warning("Can not get the URL from the registry!");
                throw new MetadataException("Can not get the URL from the registry!");
            }
            logger.info("Building service client for service at " + url);
            this.client = (MetadataService)CXFHelper.getClientFromFinalURL((String)url, MetadataService.class);
        }
        return this.client;
    }

    @WebMethod
    public void addMetadata(Resource arg0, Metadata arg1) throws MetadataException {
        logger.info("Add Metadata");
        this.getClient().addMetadata(arg0, arg1);
    }

    @WebMethod
    public boolean deleteMetaData(Resource arg0) throws MetadataException {
        logger.info("Delete Metadata");
        return this.getClient().deleteMetaData(arg0);
    }

    @WebMethod
    public List<Metadata> getMetaData(Resource arg0) throws MetadataException {
        logger.info("Get Metadata");
        return this.getClient().getMetaData(arg0);
    }

    @WebMethod
    public Metadata getMetadataValue(Resource arg0, String arg1) throws MetadataException {
        logger.info("Get MetadataValue");
        return this.getClient().getMetadataValue(arg0, arg1);
    }

    @WebMethod
    public List<MetaResource> getResoucesWithMeta(List<Metadata> arg0) throws MetadataException {
        logger.info("Add Metadata");
        return this.getClient().getResoucesWithMeta(arg0);
    }

    @WebMethod
    public List<MetaResource> list() throws MetadataException {
        return this.getClient().list();
    }

    @WebMethod
    public void removeMetadata(Resource arg0, Metadata arg1) throws MetadataException {
        this.getClient().removeMetadata(arg0, arg1);
    }

    @WebMethod
    public boolean create(MetaResource arg0) throws MetadataException {
        return this.getClient().create(arg0);
    }

    @WebMethod
    public void clear() throws MetadataException {
        this.getClient().clear();
    }

    @WebMethod
    public boolean exists(Resource arg0) throws MetadataException {
        return this.getClient().exists(arg0);
    }

    public void setMetadata(Resource arg0, Metadata arg1) throws MetadataException {
        this.getClient().setMetadata(arg0, arg1);
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

