/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.bootstrap.client;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SubscriptionRegistry;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.bootstrap.client.ServiceRegistry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class SubscriptionRegistryClient
implements SubscriptionRegistry {
    private static Logger logger = Logger.getLogger(SubscriptionRegistryClient.class.getName());
    protected ServiceRegistry registry;
    private SubscriptionRegistry client;

    protected synchronized SubscriptionRegistry getClient() throws GovernanceExeption {
        if (this.client == null) {
            if (this.registry == null) {
                logger.warning("Can not get the registry!");
                throw new GovernanceExeption("Can not get the registry");
            }
            String url = null;
            try {
                url = this.registry.get("org.ow2.play.governance.subscription.registry");
            }
            catch (RegistryException e) {
                throw new GovernanceExeption((Throwable)e);
            }
            if (url == null) {
                logger.warning("Can not get the GOVERNANCE_SUBSCRIPTION_REGISTRY URL from the registry!");
                throw new GovernanceExeption("Can not get the URL from the registry!");
            }
            logger.info("Building SubscriptionRegistry service client for service at " + url);
            this.client = (SubscriptionRegistry)CXFHelper.getClientFromFinalURL((String)url, SubscriptionRegistry.class);
        }
        return this.client;
    }

    @WebMethod
    public void addSubscription(Subscription s) throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Adding subscription to registry : " + s);
        }
        this.getClient().addSubscription(s);
    }

    @WebMethod
    public List<Subscription> getSubscriptions() throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Get Subscriptions");
        }
        return this.getClient().getSubscriptions();
    }

    @WebMethod(operationName="getFilterSubscriptions")
    public List<Subscription> getSubscriptions(@WebParam(name="filter") Subscription filter) throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Get subscriptions with filter : " + filter);
        }
        return this.getClient().getSubscriptions(filter);
    }

    @WebMethod
    public boolean remove(Subscription s) throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Remove subscription : " + s);
        }
        return this.getClient().remove(s);
    }

    @WebMethod
    public List<Subscription> removeAll() throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Remove all subscriptions");
        }
        return this.getClient().removeAll();
    }

    @WebMethod
    public List<Subscription> removeAllFromConsumer(String c) throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Remove all subscriptions from the consumer = " + c);
        }
        return this.getClient().removeAllFromConsumer(c);
    }

    @WebMethod
    public List<Subscription> removeAllFromProvider(String p) throws GovernanceExeption {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Remove all subscriptions from the provider = " + p);
        }
        return this.getClient().removeAllFromProvider(p);
    }

    public void setRegistry(ServiceRegistry registry) {
        this.registry = registry;
    }
}

