/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.bootstrap.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.ow2.play.governance.api.bean.Subscription;
import org.ow2.play.governance.bootstrap.MemoryLogServiceImpl;
import org.ow2.play.governance.bootstrap.api.BootstrapFault;
import org.ow2.play.governance.bootstrap.api.BootstrapService;
import org.ow2.play.governance.bootstrap.api.rest.InitService;
import org.ow2.play.governance.bootstrap.api.rest.beans.Subscriptions;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;

public class InitServiceImpl
implements InitService {
    protected static Logger logger = Logger.getLogger(InitServiceImpl.class.getName());
    private BootstrapService dsbSubscribesBootstrapService;
    private BootstrapService ecSubscribesBootstrapService;
    private Registry endpointRegistry;

    public Response go() {
        MemoryLogServiceImpl.get().log("Call to bootstrap service");
        ArrayList result = new ArrayList();
        result.addAll(this.dsbSubscribes2EC());
        result.addAll(this.ecSubscribes2DSB());
        return Response.ok((Object)new Subscriptions(result)).build();
    }

    public Response ecToDSB() {
        return Response.ok((Object)new Subscriptions(this.ecSubscribes2DSB())).build();
    }

    public Response dsbToEC() {
        return Response.ok((Object)new Subscriptions(this.dsbSubscribes2EC())).build();
    }

    protected List<Subscription> dsbSubscribes2EC() {
        ArrayList<Subscription> result;
        block8: {
            String subscriberEndpoint;
            String eventCloudEndpoint;
            block7: {
                MemoryLogServiceImpl.get().log("DSB subscribes to EC");
                result = new ArrayList<Subscription>();
                eventCloudEndpoint = null;
                subscriberEndpoint = null;
                try {
                    eventCloudEndpoint = this.endpointRegistry.get("org.ow2.play.dsb2ec.eventcloud");
                    subscriberEndpoint = this.endpointRegistry.get("org.ow2.play.dsb2ec.subscriber");
                }
                catch (RegistryException e1) {
                    logger.warning(e1.getMessage());
                    if (!logger.isLoggable(Level.FINE)) break block7;
                    logger.log(Level.WARNING, "Can not get data from the registry", e1);
                }
            }
            logger.info(String.format("Initializing with ec %s and subscriber %s", eventCloudEndpoint, subscriberEndpoint));
            if (eventCloudEndpoint == null || subscriberEndpoint == null) {
                logger.warning("Can not initialize with null values....");
                return result;
            }
            try {
                result.addAll(this.dsbSubscribesBootstrapService.bootstrap(eventCloudEndpoint, subscriberEndpoint));
                if (logger.isLoggable(Level.FINE)) {
                    for (Subscription s : result) {
                        logger.fine("Subscribed : " + s);
                    }
                }
            }
            catch (BootstrapFault e) {
                logger.warning(e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block8;
                logger.log(Level.WARNING, "Can not boot", e);
            }
        }
        return result;
    }

    protected List<Subscription> ecSubscribes2DSB() {
        ArrayList<Subscription> result;
        block8: {
            String dsbEndpoint;
            String eventCloudEndpoint;
            block7: {
                MemoryLogServiceImpl.get().log("EC subscribes to DSB");
                result = new ArrayList<Subscription>();
                eventCloudEndpoint = null;
                dsbEndpoint = null;
                try {
                    eventCloudEndpoint = this.endpointRegistry.get("org.ow2.play.ec2dsb.eventcloud");
                    dsbEndpoint = this.endpointRegistry.get("org.ow2.play.ec2dsb.dsb");
                }
                catch (RegistryException e1) {
                    logger.warning(e1.getMessage());
                    if (!logger.isLoggable(Level.FINE)) break block7;
                    logger.log(Level.WARNING, "Can not get data from the registry", e1);
                }
            }
            logger.info(String.format("Initializing with ec %s and dsb %s", eventCloudEndpoint, dsbEndpoint));
            if (eventCloudEndpoint == null || dsbEndpoint == null) {
                logger.warning("Can not initialize with null values....");
                return result;
            }
            try {
                result.addAll(this.ecSubscribesBootstrapService.bootstrap(dsbEndpoint, eventCloudEndpoint));
                if (logger.isLoggable(Level.FINE)) {
                    for (Subscription s : result) {
                        logger.fine("Subscribed : " + s);
                    }
                }
            }
            catch (BootstrapFault e) {
                logger.warning(e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block8;
                logger.log(Level.WARNING, "Can not boot", e);
            }
        }
        return result;
    }

    public void setDsbSubscribesBootstrapService(BootstrapService dsbSubscribesBootstrapService) {
        this.dsbSubscribesBootstrapService = dsbSubscribesBootstrapService;
    }

    public void setEcSubscribesBootstrapService(BootstrapService ecSubscribesBootstrapService) {
        this.ecSubscribesBootstrapService = ecSubscribesBootstrapService;
    }

    public void setEndpointRegistry(Registry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }
}

