/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.topic;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XPathDOMAnalyzer {
    private static Logger log = Logger.getLogger(XPathDOMAnalyzer.class.getName());

    XPathDOMAnalyzer() {
    }

    final synchronized NodeList evaluate(String string, Document document, Map<String, String> map) throws WsnbException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        NamespaceContextMap namespaceContextMap = new NamespaceContextMap(map);
        NodeList nodeList = null;
        try {
            if (document != null) {
                for (String string2 : arrayList) {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    xPath.setNamespaceContext(namespaceContextMap);
                    XPathExpression xPathExpression = xPath.compile(string2);
                    Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
                    if (!(object instanceof NodeList)) continue;
                    nodeList = (NodeList)object;
                    break;
                }
                if (nodeList == null && log.isLoggable(Level.FINE)) {
                    log.fine("No xpath expressions " + arrayList + " match with: \n " + Wsnb4ServUtils.prettyPrint(document.getOwnerDocument()));
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new WsnbException((Throwable)xPathExpressionException);
        }
        return nodeList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamespaceContextMap
    implements NamespaceContext {
        private final Map<String, String> prefixMap;
        private final Map<String, Set<String>> nsMap;

        NamespaceContextMap(Map<String, String> map) {
            this.prefixMap = this.createPrefixMap(map);
            this.nsMap = this.createNamespaceMap(this.prefixMap);
        }

        private Map<String, String> createPrefixMap(Map<String, String> map) {
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            this.addConstant(hashMap, "xml", "http://www.w3.org/XML/1998/namespace");
            this.addConstant(hashMap, "xmlns", "http://www.w3.org/2000/xmlns/");
            return Collections.unmodifiableMap(hashMap);
        }

        private void addConstant(Map<String, String> map, String string, String string2) {
            String string3 = map.put(string, string2);
            if (string3 != null && !string3.equals(string2)) {
                throw new IllegalArgumentException(string + " -> " + string3 + "; see NamespaceContext contract");
            }
        }

        private Map<String, Set<String>> createNamespaceMap(Map<String, String> map) {
            Object object;
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                object = entry.getValue();
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(object);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashMap.put((String)object, hashSet);
                }
                hashSet.add(entry.getKey());
            }
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                object = Collections.unmodifiableSet((Set)((Object)entry.getValue()));
                entry.setValue((String)object);
            }
            return hashMap;
        }

        @Override
        public String getNamespaceURI(String string) {
            this.checkNotNull(string);
            String string2 = this.prefixMap.get(string);
            return string2 == null ? "" : string2;
        }

        @Override
        public String getPrefix(String string) {
            this.checkNotNull(string);
            Set<String> set = this.nsMap.get(string);
            return set == null ? null : set.iterator().next();
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            this.checkNotNull(string);
            Set<String> set = this.nsMap.get(string);
            return set.iterator();
        }

        private void checkNotNull(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null");
            }
        }
    }
}

