/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class WsstarCommonUtils {
    private static Logger logger = Logger.getLogger(WsstarCommonUtils.class.getSimpleName());
    private static String transformerFactoryClass = "";
    private static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY_THREAD_LOCAL = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            try {
                if (System.getProperty("java.vendor").indexOf("Sun") != -1) {
                    transformerFactoryClass = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
                } else if (System.getProperty("java.vendor").indexOf("IBM") != -1) {
                    transformerFactoryClass = "org.apache.xalan.processor.TransformerFactoryImpl";
                }
                Thread.currentThread().getContextClassLoader().loadClass(transformerFactoryClass);
                System.setProperty("javax.xml.transform.TransformerFactory", transformerFactoryClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.SEVERE, "Warning. TransformerFactory '" + transformerFactoryClass + "' not found, the standard TransformerFactory will be used.");
            }
            return TransformerFactory.newInstance();
        }
    };
    private static final ThreadLocal<Transformer> DEFAULT_TRANSFORMER_THREAD_LOCAL = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException("Failed to create Transformer", transformerConfigurationException);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> JVM_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader2);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException("Failed to create DocumentBuilder", parserConfigurationException);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> NAMESPACE_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException("Failed to create DocumentBuilder", parserConfigurationException);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> DEFAULT_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException("Failed to create DocumentBuilder", parserConfigurationException);
            }
        }
    };

    private WsstarCommonUtils() {
    }

    public static Document convertFromFiletoDocument(File file) throws Exception {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new Exception(sAXException);
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Exception(parserConfigurationException);
        }
        return document;
    }

    public static String prettyPrint(Document document, String string) {
        String string2 = "";
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            WsstarCommonUtils.prettify(document, byteArrayOutputStream, string);
            string2 = byteArrayOutputStream.toString(string);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "write_dom failed:" + exception);
        }
        return string2;
    }

    public static String prettyPrint(Document document) {
        return WsstarCommonUtils.prettyPrint(document, WsstarCommonUtils.getEncoding(document));
    }

    public static void prettify(Node node, OutputStream outputStream, String string) throws TransformerException {
        DOMSource dOMSource = new DOMSource(node);
        Source source = WsstarCommonUtils.getStyleSheetSource();
        TransformerFactory transformerFactory = TRANSFORMER_FACTORY_THREAD_LOCAL.get();
        Templates templates = transformerFactory.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", string);
        transformer.transform(dOMSource, new StreamResult(outputStream));
    }

    public static String getEncoding(Document document) {
        String string = "UTF-8";
        return string;
    }

    private static Source getStyleSheetSource() {
        return new StreamSource(WsstarCommonUtils.class.getResourceAsStream("/util/prettyPrint.xsl"));
    }

    public static Transformer getDefaultTransformerFactoryThreadLocal() {
        return DEFAULT_TRANSFORMER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getJvmDocumentBuilder() {
        return JVM_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getNamespaceDocumentBuilder() {
        return NAMESPACE_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getDefaultDocumentBuilder() {
        return DEFAULT_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }
}

