/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.dsb.wsn.component;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.play.governance.api.TopicAware;
import org.ow2.play.governance.api.bean.Topic;
import org.petalslink.dsb.jbi.se.wsn.api.ManagementService;

public class TopicAwareService
implements TopicAware {
    private ManagementService management;
    private Logger logger;

    public TopicAwareService(ManagementService management, Logger logger) {
        this.management = management;
        this.logger = logger;
    }

    public boolean add(Topic topic) {
        this.logger.info("Adding a topic : " + topic);
        if (topic == null) {
            return false;
        }
        this.management.add(this.to(topic));
        return true;
    }

    public boolean delete(Topic topic) {
        this.logger.info("Deleting topic : " + topic);
        if (topic == null) {
            return false;
        }
        this.management.delete(this.to(topic));
        return true;
    }

    public List<Topic> get() {
        this.logger.info("Get topics");
        return Lists.transform((List)this.management.getTopics(), (Function)new Function<org.petalslink.dsb.jbi.se.wsn.api.Topic, Topic>(){

            public Topic apply(org.petalslink.dsb.jbi.se.wsn.api.Topic t) {
                Topic result = new Topic();
                result.setName(t.name);
                result.setNs(t.ns);
                result.setPrefix(t.prefix);
                return result;
            }
        });
    }

    protected org.petalslink.dsb.jbi.se.wsn.api.Topic to(Topic topic) {
        org.petalslink.dsb.jbi.se.wsn.api.Topic result = new org.petalslink.dsb.jbi.se.wsn.api.Topic();
        result.name = topic.getName();
        result.ns = topic.getNs();
        result.prefix = topic.getPrefix();
        return result;
    }
}

