/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.petals.component.framework.ComponentInformation;
import org.ow2.petals.component.framework.PetalsBindingComponent;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.petalslink.dsb.jbi.se.wsn.api.ManagementService;
import org.petalslink.dsb.jbi.se.wsn.api.NotificationService;
import org.petalslink.dsb.jbi.se.wsn.api.StatsService;
import org.petalslink.dsb.jbi.se.wsn.api.SubscriptionService;
import org.petalslink.dsb.jbi.se.wsn.services.ManagementServiceImpl;
import org.petalslink.dsb.jbi.se.wsn.services.NotificationServiceImpl;
import org.petalslink.dsb.jbi.se.wsn.services.StatsServiceImpl;
import org.petalslink.dsb.jbi.se.wsn.services.SubscriptionServiceImpl;
import org.petalslink.dsb.notification.commons.PropertiesConfigurationProducer;
import org.petalslink.dsb.service.client.Client;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends PetalsBindingComponent {
    public static final String FILE_CFG = "notification.cfg";
    public static final String TOPICS_NS_FILE = "topics/business-topicns-rpupdate.xml";
    public static final String TOPICSET_FILE = "topics/business-topicset.xml";
    public static final String ENDPOINT_NAME = "endpoint";
    public static final String INTERFACE_NAME = "interface";
    public static final String SERVICE_NAME = "service";
    protected NotificationEngine engine;
    protected Client httpClient;
    private Map<ServiceEndpointKey, Wsdl> WSNEP;
    protected List<org.petalslink.dsb.commons.service.api.Service> ws;
    protected StatsService stats;
    protected ManagementService managementService;
    protected SubscriptionService subscriptionService;
    protected NotificationService notificationService;

    @Override
    protected void postDoInit() throws JBIException {
        this.ws = new ArrayList<org.petalslink.dsb.commons.service.api.Service>();
        this.WSNEP = new ConcurrentHashMap<ServiceEndpointKey, Wsdl>();
        this.initializeNotificationEngine();
        this.addServices();
    }

    protected void addServices() {
        this.stats = new StatsServiceImpl(this.getLogger());
        this.ws.add(this.getService(StatsService.class, this.stats, "StatsService"));
        this.managementService = new ManagementServiceImpl(this.engine, this.getLogger());
        this.ws.add(this.getService(ManagementService.class, this.managementService, "ManagementService"));
        this.subscriptionService = new SubscriptionServiceImpl(this.engine, this.getLogger());
        this.ws.add(this.getService(SubscriptionService.class, this.subscriptionService, "SubscriptionService"));
        this.notificationService = new NotificationServiceImpl(this.engine, this.getLogger());
        this.ws.add(this.getService(NotificationService.class, this.notificationService, "NotificationService"));
        this.doAddServices();
    }

    protected void doAddServices() {
    }

    protected org.petalslink.dsb.commons.service.api.Service getService(Class<?> clazz, Object bean, String serviceName) {
        String port = this.getContainerConfiguration("http.port") == null ? "8079" : this.getContainerConfiguration("http.port");
        String host = this.getContainerConfiguration("http.host") == null ? "localhost" : this.getContainerConfiguration("http.host");
        return CXFHelper.getServiceFromFinalURL((String)("http://" + host + ":" + port + "/" + this.getContext().getComponentName() + "/" + serviceName), clazz, (Object)bean);
    }

    protected void initializeNotificationEngine() throws JBIException {
        Properties props = new Properties();
        try {
            props.load(Component.class.getClassLoader().getResourceAsStream(FILE_CFG));
        }
        catch (IOException e) {
            throw new JBIException("Can not find the notification configuration file");
        }
        URL topics = Component.class.getClassLoader().getResource(TOPICSET_FILE);
        if (topics == null) {
            throw new JBIException("Can not find the notification topicnamespace configuration file");
        }
        URL tns = Component.class.getClassLoader().getResource(TOPICS_NS_FILE);
        if (tns == null) {
            throw new JBIException("Can not find the notification topicnamespace configuration file");
        }
        String endpointName = props.getProperty(ENDPOINT_NAME);
        QName interfaceName = QName.valueOf(props.getProperty(INTERFACE_NAME));
        QName serviceName = QName.valueOf(props.getProperty(SERVICE_NAME));
        if (this.engine == null) {
            this.engine = new NotificationEngine(this.getLogger(), serviceName, interfaceName, endpointName, this.getClient());
        }
        this.engine.init(topics, tns);
    }

    @Override
    protected void doStart() throws JBIException {
        this.activateWSNEndpoints();
        this.createSubscribers();
        this.startWebServices();
    }

    protected void startWebServices() {
        if (this.ws != null) {
            int i = 0;
            for (org.petalslink.dsb.commons.service.api.Service service : this.ws) {
                try {
                    this.getLogger().info("Starting service at " + service.getURL());
                    service.start();
                    ComponentInformation info = this.getPlugin(ComponentInformation.class);
                    if (info == null) continue;
                    info.addProperty(this.getContext().getComponentName() + "-managementws-" + i++, service.getURL());
                }
                catch (Exception e) {
                    this.getLogger().warning(e.getMessage());
                }
            }
        }
        this.getLogger().info("Web services started");
    }

    protected void createSubscribers() {
        URL subscribers = Component.class.getClassLoader().getResource("subscribers.cfg");
        Properties subscriberProps = null;
        if (subscribers != null) {
            subscriberProps = new Properties();
            try {
                subscriberProps.load(Component.class.getClassLoader().getResourceAsStream("subscribers.cfg"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (subscriberProps != null) {
            PropertiesConfigurationProducer producers = new PropertiesConfigurationProducer(subscriberProps);
            List toSubscribe = producers.getSubscribes();
            for (Subscribe subscribe : toSubscribe) {
                try {
                    if (this.getLogger().isLoggable(Level.INFO)) {
                        this.getLogger().info("Subscribe request : ");
                        if (subscribe != null) {
                            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
                            this.getLogger().info(XMLHelper.createStringFromDOMDocument((Node)doc));
                        }
                    }
                    SubscribeResponse subscribeResponse = this.getNotificationEngine().getNotificationManager().getNotificationProducerEngine().subscribe(subscribe);
                    if (!this.getLogger().isLoggable(Level.INFO)) continue;
                    this.getLogger().info("Subscribe response");
                    if (subscribeResponse != null) {
                        Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeResponseAsDOM(subscribeResponse);
                        this.getLogger().info(XMLHelper.createStringFromDOMDocument((Node)doc));
                        continue;
                    }
                    this.getLogger().info("No response...");
                }
                catch (Exception e) {
                    if (!this.getLogger().isLoggable(Level.FINE)) continue;
                    this.getLogger().log(Level.INFO, "Problem while subscribing", e);
                }
            }
        }
    }

    private void activateWSNEndpoints() throws JBIException {
        Endpoint endpoint;
        Iterator<Endpoint> iterator;
        List<Endpoint> endpointList = null;
        QName serviceName = null;
        String endpointName = null;
        endpointList = WSDLUtilImpl.getEndpointList(this.engine.getProducerWSDL().getDescription());
        if (endpointList != null && (iterator = endpointList.iterator()) != null) {
            while (iterator.hasNext()) {
                endpoint = iterator.next();
                if (endpoint == null) continue;
                serviceName = ((Service)endpoint.getService()).getQName();
                endpointName = endpoint.getName();
                this.activateWSNEndpoint(serviceName, endpointName, this.engine.getProducerWSDL());
            }
        }
        if ((endpointList = WSDLUtilImpl.getEndpointList(this.engine.getConsumerWSDL().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
            while (iterator.hasNext()) {
                endpoint = iterator.next();
                if (endpoint == null) continue;
                serviceName = ((Service)endpoint.getService()).getQName();
                endpointName = endpoint.getName();
                this.activateWSNEndpoint(serviceName, endpointName, this.engine.getConsumerWSDL());
            }
        }
    }

    private void activateWSNEndpoint(QName serviceName, String endpointName, Wsdl wsdl) throws JBIException {
        this.WSNEP.put(new ServiceEndpointKey(serviceName, endpointName), wsdl);
        try {
            this.context.activateEndpoint(serviceName, endpointName);
        }
        catch (Exception e) {
            this.WSNEP.remove(new ServiceEndpointKey(serviceName, endpointName));
        }
    }

    @Override
    protected void doStop() throws JBIException {
        if (this.ws != null) {
            for (org.petalslink.dsb.commons.service.api.Service service : this.ws) {
                try {
                    service.stop();
                }
                catch (Exception e) {
                    this.getLogger().warning(e.getMessage());
                }
            }
        }
    }

    @Override
    protected void doShutdown() throws JBIException {
    }

    @Override
    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (this.isNotification(endpoint)) {
            return this.getWSNDescription(endpoint);
        }
        return super.getServiceDescription(endpoint);
    }

    private Document getWSNDescription(ServiceEndpoint endpoint) {
        Wsdl desc = this.WSNEP.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName()));
        if (desc != null) {
            return desc.getDocument();
        }
        return null;
    }

    public NotificationEngine getNotificationEngine() {
        return this.engine;
    }

    private boolean isNotification(ServiceEndpoint endpoint) {
        return this.WSNEP.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName())) != null;
    }

    protected synchronized Client getClient() {
        if (this.httpClient == null) {
            this.httpClient = new org.petalslink.dsb.service.client.saaj.Client();
        }
        return this.httpClient;
    }
}

