/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsaddressing10.api.type.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.AbsNotificationConsumerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.petalslink.dsb.api.util.EndpointHelper;
import org.petalslink.dsb.jbi.se.wsn.AddressingHelper;
import org.petalslink.dsb.jbi.se.wsn.ServiceEngine;
import org.petalslink.dsb.jbi.se.wsn.Stats;
import org.petalslink.dsb.jbi.se.wsn.TopicSetHelper;
import org.petalslink.dsb.jbi.se.wsn.api.Topic;
import org.petalslink.dsb.notification.commons.AbstractNotificationSender;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.petalslink.dsb.notification.commons.NotificationManagerImpl;
import org.petalslink.dsb.notification.commons.api.NotificationManager;
import org.petalslink.dsb.notification.service.NotificationProducerRPService;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageImpl;
import org.petalslink.dsb.service.client.WSAMessageImpl;
import org.petalslink.dsb.soap.api.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationEngine {
    private Logger logger;
    NotificationManager notificationManager;
    private QName serviceName;
    private QName interfaceName;
    private String endpointName;
    private AbsNotificationConsumerEngine notificationConsumerEngine;
    private AbstractNotificationSender internalNotificationSender;
    Wsdl consumerWSDL;
    Wsdl producerWSDL;
    private Client client;
    private ServiceEngine serviceEngine;

    public NotificationEngine(Logger logger, QName serviceName, QName interfaceName, String endpointName, Client client) {
        this.logger = logger;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        this.endpointName = endpointName;
        this.client = client;
    }

    public void init(URL topicSet, URL topicNamespaces) {
        this.notificationManager = new NotificationManagerImpl(topicSet, topicNamespaces, this.serviceName, this.interfaceName, this.endpointName);
        this.init();
    }

    public void init(Document topicSet, Document topicNamespaces) {
        this.notificationManager = new NotificationManagerImpl(topicSet, topicNamespaces, this.serviceName, this.interfaceName, this.endpointName);
        this.init();
    }

    protected void init() {
        this.internalNotificationSender = this.getHTTPSender();
        this.notificationConsumerEngine = new AbsNotificationConsumerEngine(this.logger){

            public void notify(Notify notify) {
                if (this.logger.isLoggable(Level.FINE)) {
                    StringBuffer trace = new StringBuffer("--- Got a notify, forward to internal engine ---\n");
                    try {
                        Document doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                        trace.append(XMLHelper.createStringFromDOMDocument((Node)doc));
                    }
                    catch (Exception e) {
                        trace.append("Serialization problem : ");
                        trace.append(e.getMessage());
                    }
                    trace.append("\n-------------------------\n");
                    this.logger.fine(trace.toString());
                }
                try {
                    NotificationEngine.this.internalNotificationSender.notify(notify);
                }
                catch (NotificationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.consumerWSDL = this.loadDocument("WS-NotificationConsumer.wsdl");
        this.producerWSDL = this.loadDocument("WS-NotificationProducer.wsdl");
        this.serviceEngine = new ServiceEngine();
        this.serviceEngine.addService((Service)new NotificationProducerRPService(null, null, null, null, null, (INotificationProducerRP)this.getNotificationManager().getNotificationProducerEngine()), new QName[]{new QName("http://docs.oasis-open.org/wsrf/r-2", "GetResourceProperty"), new QName("http://docs.oasis-open.org/wsrf/r-2", "UpdateResourceProperties")});
    }

    private Wsdl loadDocument(String string) {
        try {
            return new ComponentWsdl(WSDLUtilImpl.createWsdlDescription(AbstractComponent.class.getResource("/" + string)));
        }
        catch (WSDLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public Wsdl getConsumerWSDL() {
        return this.consumerWSDL;
    }

    public Wsdl getProducerWSDL() {
        return this.producerWSDL;
    }

    public AbsNotificationConsumerEngine getNotificationConsumerEngine() {
        return this.notificationConsumerEngine;
    }

    public ServiceEngine getServiceEngine() {
        return this.serviceEngine;
    }

    protected AbstractNotificationSender getHTTPSender() {
        return new AbstractNotificationSender(this.getNotificationManager().getNotificationProducerEngine()){

            protected String getProducerAddress() {
                return "petals://" + NotificationEngine.this.endpointName;
            }

            protected void doNotify(Notify notify, String producerAddress, EndpointReferenceType currentConsumerEdp, String subscriptionId, QName topic, String dialect) throws NotificationException {
                if (currentConsumerEdp == null || currentConsumerEdp.getAddress() == null || currentConsumerEdp.getAddress().getValue() == null) {
                    NotificationEngine.this.logger.fine("No address found, do not send notification");
                    return;
                }
                if (NotificationEngine.this.logger.isLoggable(Level.INFO)) {
                    NotificationEngine.this.logger.info("Need to send the message to a subscriber which is : " + currentConsumerEdp.getAddress().getValue() + " on topic " + topic);
                }
                URI uri = currentConsumerEdp.getAddress().getValue();
                MessageImpl message = null;
                if (EndpointHelper.isDSBService((URI)uri)) {
                    NotificationEngine.this.logger.warning("This client does not handle DSB services");
                    return;
                }
                if (!AddressingHelper.isExternalService(uri)) {
                    NotificationEngine.this.logger.warning("This client does not handle internal services");
                    return;
                }
                message = new MessageImpl();
                try {
                    Document payload = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                    message.setEndpoint(currentConsumerEdp.getAddress().getValue().toString());
                    message.setPayload(payload);
                    message.setOperation(WsnbConstants.NOTIFY_QNAME);
                    NotificationEngine.this.client.sendReceive((Message)message);
                    Stats.getInstance().newOutNotifyCall(topic);
                }
                catch (ClientException e) {
                    if (NotificationEngine.this.logger.isLoggable(Level.FINE)) {
                        NotificationEngine.this.logger.log(Level.FINE, "Client got error while sending notification to " + currentConsumerEdp.getAddress().getValue() + " on topic " + topic, e);
                    } else {
                        NotificationEngine.this.logger.log(Level.INFO, "Client got error while sending notification to endpoint " + currentConsumerEdp.getAddress().getValue() + " on topic " + topic);
                    }
                }
                catch (WsnbException e) {
                    if (NotificationEngine.this.logger.isLoggable(Level.FINE)) {
                        NotificationEngine.this.logger.log(Level.FINE, "WSN error while sending notification to " + currentConsumerEdp.getAddress().getValue() + " on topic " + topic, e);
                    }
                    NotificationEngine.this.logger.log(Level.INFO, "WSN error while sending notification to endpoint " + currentConsumerEdp.getAddress().getValue() + " on topic " + topic);
                }
            }
        };
    }

    protected AbstractNotificationSender getDSBSender() {
        return new AbstractNotificationSender(this.getNotificationManager().getNotificationProducerEngine()){

            protected String getProducerAddress() {
                return "jbi://" + NotificationEngine.this.endpointName;
            }

            protected void doNotify(Notify notify, String producerAddress, EndpointReferenceType currentConsumerEdp, String subscriptionId, QName topic, String dialect) throws NotificationException {
                if (currentConsumerEdp == null || currentConsumerEdp.getAddress() == null || currentConsumerEdp.getAddress().getValue() == null) {
                    NotificationEngine.this.logger.fine("No address found, do not send notification");
                    return;
                }
                if (NotificationEngine.this.logger.isLoggable(Level.FINE)) {
                    NotificationEngine.this.logger.fine("Need to send the message to a subscriber which is : " + currentConsumerEdp.getAddress().getValue());
                }
                URI uri = currentConsumerEdp.getAddress().getValue();
                MessageImpl message = null;
                if (EndpointHelper.isDSBService((URI)uri)) {
                    message = new MessageImpl();
                    message.setEndpoint(EndpointHelper.getEndpoint((URI)uri));
                    message.setService(EndpointHelper.getService((URI)uri));
                } else if (AddressingHelper.isExternalService(uri)) {
                    message = new WSAMessageImpl(uri.toString());
                } else {
                    System.out.println("Internal service : TODO NotificationEngine class!");
                    return;
                }
                try {
                    Document payload = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                    message.setPayload(payload);
                    message.setOperation(WsnbConstants.NOTIFY_QNAME);
                    NotificationEngine.this.client.fireAndForget((Message)message);
                }
                catch (ClientException e) {
                    e.printStackTrace();
                }
                catch (WsnbException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public String subscribe(QName topic, String subscriber) {
        String result = null;
        try {
            Subscribe subscribe = NotificationHelper.createSubscribe((String)subscriber, (QName)topic);
            SubscribeResponse response = this.getNotificationManager().getNotificationProducerEngine().subscribe(subscribe);
            if (response != null && response.getSubscriptionReference() != null && response.getSubscriptionReference().getReferenceParameters() != null) {
                result = Wsnb4ServUtils.getSubscriptionIdFromReferenceParams((ReferenceParametersType)response.getSubscriptionReference().getReferenceParameters());
            }
        }
        catch (Exception e) {
            e.getMessage();
            this.logger.warning(e.getMessage());
        }
        return result;
    }

    public void notify(QName topic, Document payload) {
        try {
            Notify notify = NotificationHelper.createNotification(null, null, null, (QName)topic, (String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (Document)payload);
            this.notificationConsumerEngine.notify(notify);
        }
        catch (NotificationException e) {
            e.printStackTrace();
        }
    }

    public void updateTopicSet(List<Topic> topicSet) {
        if (topicSet == null) {
            return;
        }
        this.updateTopicSet(TopicSetHelper.getWSNDocument(topicSet));
    }

    public void updateTopicSet(Document topicSet) {
        if (topicSet == null) {
            this.logger.warning("Can not set a null topicset");
            return;
        }
        try {
            TopicSetType newTopicSetRP = Wsnb4ServUtils.getWstopReader().readTopicSetType(topicSet);
            Document topicSetAsDOM = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(newTopicSetRP);
            ArrayList<Element> properties = new ArrayList<Element>();
            properties.add(topicSetAsDOM.getDocumentElement());
            UpdateType content = RefinedWsrfrpFactory.getInstance().createUpdateType(properties);
            UpdateResourceProperties update = RefinedWsrfrpFactory.getInstance().createUpdateResourceProperties(content);
            UpdateResourcePropertiesResponse response = this.notificationManager.getNotificationProducerEngine().updateResourceProperties(update);
            if (this.logger.isLoggable(Level.INFO)) {
                if (response == null) {
                    this.logger.fine("No response returned from the engine in update topicset");
                } else {
                    this.logger.info("Topicset update response " + XMLHelper.createStringFromDOMDocument((Node)RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeUpdateResourcePropertiesResponseAsDOM(response)));
                }
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.WARNING, "Can not update the resources", e);
            }
            this.logger.log(Level.WARNING, "Can not update the resources : " + e.getMessage());
        }
        this.logger.info("Topics has been updated");
    }

    public List<Topic> getTopics() {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        TopicSetType tst = this.notificationManager.getTopicSet();
        if (this.logger.isLoggable(Level.FINE)) {
            try {
                this.logger.fine("Current topicset " + XMLHelper.createStringFromDOMDocument((Node)Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(tst)));
            }
            catch (Exception e1) {
                this.logger.warning(e1.getMessage());
            }
        }
        for (Element e : tst.getTopicsTrees()) {
            String nodeName = e.getNodeName();
            String prefix = null;
            if (nodeName.contains(":")) {
                prefix = nodeName.substring(0, nodeName.lastIndexOf(58));
                nodeName = nodeName.substring(nodeName.lastIndexOf(58) + 1);
            }
            String ns = e.getAttribute("xmlns:" + prefix);
            Topic t = new Topic();
            t.name = nodeName;
            t.prefix = prefix;
            t.ns = ns;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Topic " + t);
            }
            topics.add(t);
        }
        return topics;
    }
}

