/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.listeners;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.petalslink.dsb.jbi.se.wsn.AddressingHelper;
import org.petalslink.dsb.jbi.se.wsn.Component;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NotificationV2JBIListener
extends AbstractJBIListener {
    static final String LOCATION_COMPONENT = "consumer.location.component";
    static final String LOCATION_CONTAINER = "consumer.location.container";
    static final String LOCATION_DOMAIN = "consumer.location.domain";

    public boolean onJBIMessage(Exchange exchange) {
        boolean response;
        block30: {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(String.format("We have a notification message with operation '%s'", exchange.getOperation()));
            }
            NotificationEngine engine = this.getNotificationEngine();
            response = true;
            NormalizedMessage normalizedMessage = null;
            Document document = null;
            Object address = null;
            try {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    for (QName intf : exchange.getEndpoint().getInterfaces()) {
                        this.getLogger().fine("notification endpoint interface: " + intf);
                    }
                    this.getLogger().fine("notification endpoint service: " + exchange.getEndpoint().getServiceName());
                    this.getLogger().fine("notification endpoint name: " + exchange.getEndpoint().getEndpointName());
                    this.getLogger().fine("notification operation name: " + exchange.getOperationName());
                }
                if (!exchange.isActiveStatus()) break block30;
                if (exchange.getFault() != null) {
                    if (this.getLogger().isLoggable(Level.WARNING)) {
                        this.getLogger().warning("notification business fault message content: " + SourceUtil.createString(exchange.getFault().getContent()));
                    }
                    break block30;
                }
                normalizedMessage = exchange.getInMessage();
                document = SourceUtil.createDocument(normalizedMessage.getContent());
                if (this.getLogger().isLoggable(Level.FINE)) {
                    try {
                        this.getLogger().fine("Input message : " + XMLHelper.createStringFromDOMDocument((Node)document));
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
                if (WsnbConstants.SUBSCRIBE_QNAME.getLocalPart().equals(exchange.getOperation().getLocalPart())) {
                    String domain;
                    document = SourceUtil.createDocument(normalizedMessage.getContent());
                    Subscribe subscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readSubscribe(document);
                    Address consumerAddress = subscribe.getConsumerReference().getAddress();
                    URI value = consumerAddress.getValue();
                    this.getLogger().log(Level.FINE, String.format("Subscribe with Initial address is '%s'", value));
                    String component = exchange.getProperty(LOCATION_COMPONENT) != null ? exchange.getProperty(LOCATION_COMPONENT).toString() : null;
                    String container = exchange.getProperty(LOCATION_CONTAINER) != null ? exchange.getProperty(LOCATION_CONTAINER).toString() : null;
                    String string = domain = exchange.getProperty(LOCATION_DOMAIN) != null ? exchange.getProperty(LOCATION_DOMAIN).toString() : null;
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        this.getLogger().log(Level.FINE, String.format("Source location is component='%s' container='%s' domain='%s'", component, container, domain));
                    }
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        Document dom = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
                        try {
                            this.getLogger().fine(XMLHelper.createStringFromDOMDocument((Node)dom));
                        }
                        catch (TransformerException e) {
                            // empty catch block
                        }
                    }
                    SubscribeResponse subscribeResponse = engine.getNotificationManager().getNotificationProducerEngine().subscribe(subscribe);
                    document = RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscribeResponseAsDOM(subscribeResponse);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)SourceUtil.createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                    break block30;
                }
                if (WsnbConstants.NOTIFY_QNAME.getLocalPart().equals(exchange.getOperation().getLocalPart())) {
                    this.getLogger().fine("Got a notify message");
                    Notify notify = RefinedWsnbFactory.getInstance().getWsnbReader().readNotify(document);
                    List notificationMessageList = notify.getNotificationMessage();
                    if (notificationMessageList == null || notificationMessageList.size() != 1) {
                        exchange.setError(new Exception("The CDK need one and only one notification message"));
                    }
                    engine.getNotificationConsumerEngine().notify(notify);
                } else if ("Unsubscribe".equals(exchange.getOperation().getLocalPart())) {
                    this.getLogger().log(Level.INFO, "Got an unsubscribe message");
                    document = SourceUtil.createDocument(normalizedMessage.getContent());
                    Unsubscribe unsubscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readUnsubscribe(document);
                    UnsubscribeResponse unsubscribeResponse = engine.getNotificationManager().getSubscriptionManagerEngine().unsubscribe(unsubscribe);
                    document = RefinedWsnbFactory.getInstance().getWsnbWriter().writeUnsubscribeResponseAsDOM(unsubscribeResponse);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)SourceUtil.createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                } else if (WsnbConstants.GET_CURRENT_MESSAGE_QNAME.getLocalPart().equals(exchange.getOperation().getLocalPart())) {
                    this.getLogger().log(Level.WARNING, "GET_CURRENT_MESSAGE_QNAME not implemented");
                } else if (WsnbConstants.RENEW_QNAME.getLocalPart().equals(exchange.getOperation().getLocalPart())) {
                    this.getLogger().log(Level.WARNING, "RENEW_QNAME not implemented");
                } else if ("GetResourceProperty".equals(exchange.getOperation().getLocalPart())) {
                    this.getLogger().log(Level.INFO, "Got an GetResourceProperty message");
                    document = SourceUtil.createDocument(normalizedMessage.getContent());
                    QName qname = RefinedWsrfrpFactory.getInstance().getWsrfrpReader().readGetResourceProperty(document);
                    GetResourcePropertyResponse res = engine.getNotificationManager().getNotificationProducerEngine().getResourceProperty(qname);
                    document = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeGetResourcePropertyResponseAsDOM(res);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)SourceUtil.createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                } else {
                    exchange.setError(new Exception(String.format("unable to identify the operation %s of the WS-Notification specifications, or not implemented", exchange.getOperation())));
                }
            }
            catch (PEtALSCDKException e) {
                exchange.setError(new Exception(e));
            }
            catch (WsnbException e) {
                exchange.setError(new Exception(e));
            }
            catch (AbsWSStarFault e) {
                exchange.setError(new Exception(e));
            }
            catch (MessagingException e) {
                exchange.setError(new Exception(e));
            }
            catch (WsrfrpException e) {
                exchange.setError(new Exception(e));
            }
        }
        return response;
    }

    private void addLocation(Address address, String component, String container, String domain) {
        if (address == null) {
            return;
        }
        URI uri = address.getValue();
        if (AddressingHelper.isInternalService(uri)) {
            address.setValue(AddressingHelper.addLocation(uri, component, container, domain));
        } else if (AddressingHelper.isExternalService(uri)) {
            String tmp = uri.toString();
            if (!tmp.startsWith("http://dsb.petalslink.org/service/external/")) {
                tmp = "http://dsb.petalslink.org/service/external/::" + uri.toString();
            }
            address.setValue(AddressingHelper.addLocation(URI.create(tmp), component, container, domain));
        }
    }

    NotificationEngine getNotificationEngine() {
        return ((Component)this.getComponent()).getNotificationEngine();
    }
}

