/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.services;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.petalslink.dsb.jbi.se.wsn.api.ManagementService;
import org.petalslink.dsb.jbi.se.wsn.api.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementServiceImpl
implements ManagementService {
    private NotificationEngine engine;
    private Logger logger;
    final Object lock = new Object();

    public ManagementServiceImpl(NotificationEngine engine, Logger logger) {
        this.engine = engine;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Topic topic) {
        List<Topic> topics;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Adding topic " + topic);
        }
        if ((topics = this.getTopics()) == null) {
            return;
        }
        if (topics.contains(topic)) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Topic is already in the list " + topic);
            }
            return;
        }
        Iterator<Topic> iter = topics.iterator();
        while (iter.hasNext()) {
            Topic t = iter.next();
            if (!"RPUpdate".equals(t.name)) continue;
            iter.remove();
        }
        topics.add(topic);
        Object object = this.lock;
        synchronized (object) {
            this.logger.fine("Updating topics for add");
            this.engine.updateTopicSet(topics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Topic topic) {
        List<Topic> topics;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Deleting topic " + topic);
        }
        if ((topics = this.getTopics()) == null) {
            return false;
        }
        Iterator<Topic> iter = topics.iterator();
        while (iter.hasNext()) {
            Topic t = iter.next();
            if (!"RPUpdate".equals(t.name)) continue;
            iter.remove();
        }
        topics.remove(topic);
        Object object = this.lock;
        synchronized (object) {
            this.logger.info("Updating topics for delete");
            this.engine.updateTopicSet(topics);
        }
        return true;
    }

    public List<Topic> getTopics() {
        return this.engine.getTopics();
    }

    public void setTopics(List<Topic> topics) {
        if (topics == null || topics.size() == 0) {
            this.logger.warning("Can not update with null topics...");
            return;
        }
        this.engine.updateTopicSet(topics);
    }
}

