/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.petalslink.dsb.jbi.se.wsn.Stats;
import org.petalslink.dsb.jbi.se.wsn.api.StatsService;
import org.petalslink.dsb.jbi.se.wsn.api.Topic;
import org.petalslink.dsb.jbi.se.wsn.api.TopicStat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsServiceImpl
implements StatsService {
    private Logger logger;

    public StatsServiceImpl(Logger logger) {
        this.logger = logger;
    }

    public List<Topic> getTopics() {
        this.logger.info("Get topics");
        return new ArrayList<Topic>();
    }

    public long getNbInNotifyMessage(Topic topic) {
        this.logger.fine("getInNbNotifyMessage for topic " + topic);
        return Stats.getInstance().getInNotifyPerTopic().get(topic) == null ? 0L : Stats.getInstance().getInNotifyPerTopic().get(topic).get();
    }

    public long getNbOutNotifyMessage(Topic topic) {
        this.logger.fine("getOutNbNotifyMessage for topic " + topic);
        return Stats.getInstance().getInNotifyPerTopic().get(topic) == null ? 0L : Stats.getInstance().getInNotifyPerTopic().get(topic).get();
    }

    public long getNbSubscribeMessage(Topic topic) {
        this.logger.fine("getNbSubscribeMessage for topic " + topic);
        return 0L;
    }

    public List<TopicStat> getInStats() {
        this.logger.fine("getInStats");
        Map<Topic, AtomicLong> stats = Stats.getInstance().getInNotifyPerTopic();
        ArrayList<TopicStat> result = new ArrayList<TopicStat>();
        for (Map.Entry<Topic, AtomicLong> e : stats.entrySet()) {
            TopicStat stat = new TopicStat();
            stat.calls = e.getValue().get();
            stat.topic = e.getKey();
            result.add(stat);
        }
        return result;
    }

    public List<TopicStat> getOutStats() {
        this.logger.fine("getInStats");
        Map<Topic, AtomicLong> stats = Stats.getInstance().getOutNotifyPerTopic();
        ArrayList<TopicStat> result = new ArrayList<TopicStat>();
        for (Map.Entry<Topic, AtomicLong> e : stats.entrySet()) {
            TopicStat stat = new TopicStat();
            stat.calls = e.getValue().get();
            stat.topic = e.getKey();
            result.add(stat);
        }
        return result;
    }
}

