/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.topics.datatypes.api.utils;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WstopDatatypeUtils {
    private WstopDatatypeUtils() {
    }

    public static TopicSetType addTopicsFromTopicNamespaceToTopicSet(TopicSetType topicSetType, TopicNamespaceType topicNamespaceType, String string) throws WstopException {
        TopicSetType topicSetType2 = RefinedWstopFactory.getInstance().createTopicSetType();
        for (Element object2 : topicSetType.getTopicsTrees()) {
            topicSetType2.addTopicsTree(object2);
        }
        List<Element> list = WstopDatatypeUtils.fromTopicNamespaceToTopicTreesElt(topicNamespaceType, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            topicSetType2.addTopicsTree(element);
        }
        return topicSetType2;
    }

    private static List<Element> fromTopicNamespaceToTopicTreesElt(TopicNamespaceType topicNamespaceType, String string) throws WstopException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        List<Object> list = new ArrayList();
        if (topicNamespaceType != null) {
            list = topicNamespaceType.getTopics();
            Document document = null;
            try {
                document = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new WstopException(parserConfigurationException);
            }
            List<TopicType> list2 = null;
            for (TopicNamespaceType.Topic topic : list) {
                Element element = document.createElementNS(topicNamespaceType.getNamespace().toString(), topic.getName());
                Attr attr = document.createAttributeNS("http://docs.oasis-open.org/wsn/t-1", "topic");
                attr.setPrefix("wstop");
                attr.setNodeValue("true");
                element.setPrefix(string);
                element.setAttributeNodeNS(attr);
                list2 = topic.getTopics();
                if (list2 != null && list2.size() > 0) {
                    try {
                        element.appendChild(WstopDatatypeUtils.addChildren(element, topic.getTopics(), document, (Attr)attr.cloneNode(true)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    private static Element addChildren(Element element, List<TopicType> list, Document document, Attr attr) {
        Element element2 = null;
        Element element3 = null;
        List<TopicType> list2 = null;
        for (TopicType topicType : list) {
            element3 = document.createElement(topicType.getName());
            element3.setAttributeNodeNS((Attr)attr.cloneNode(true));
            list2 = topicType.getTopics();
            if (list2 == null || list2.size() <= 0) continue;
            element.appendChild(WstopDatatypeUtils.addChildren(element3, topicType.getTopics(), document, (Attr)attr.cloneNode(true)));
        }
        return element2;
    }
}

