/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import org.petalslink.dsb.jbi.se.wsn.api.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats {
    private static Stats instance;
    private AtomicLong calls = new AtomicLong(0L);
    private Map<Topic, AtomicLong> inNotifyPerTopic;
    private Map<Topic, AtomicLong> outNotifyPerTopic;
    private Set<Topic> topics;

    private Stats() {
        this.init();
    }

    public static synchronized Stats getInstance() {
        if (instance == null) {
            instance = new Stats();
        }
        return instance;
    }

    public void init() {
        this.calls = new AtomicLong(0L);
        this.inNotifyPerTopic = new ConcurrentHashMap<Topic, AtomicLong>();
        this.outNotifyPerTopic = new ConcurrentHashMap<Topic, AtomicLong>();
        this.topics = new HashSet<Topic>();
    }

    public long getCalls() {
        return this.calls.get();
    }

    public void newInNotifyCall(QName topic) {
        if (topic == null) {
            return;
        }
        Topic t = Stats.topic(topic);
        this.topics.add(t);
        if (this.inNotifyPerTopic.get(t) == null) {
            this.inNotifyPerTopic.put(t, new AtomicLong(0L));
        }
        this.inNotifyPerTopic.get(t).incrementAndGet();
    }

    public void newOutNotifyCall(QName topic) {
        if (topic == null) {
            return;
        }
        Topic t = Stats.topic(topic);
        this.topics.add(t);
        if (this.outNotifyPerTopic.get(t) == null) {
            this.outNotifyPerTopic.put(t, new AtomicLong(0L));
        }
        this.outNotifyPerTopic.get(t).incrementAndGet();
    }

    public Map<Topic, AtomicLong> getInNotifyPerTopic() {
        return this.inNotifyPerTopic;
    }

    public Map<Topic, AtomicLong> getOutNotifyPerTopic() {
        return this.outNotifyPerTopic;
    }

    private static final Topic topic(QName topic) {
        Topic t = new Topic();
        t.name = topic.getLocalPart();
        t.ns = topic.getNamespaceURI();
        t.prefix = topic.getPrefix();
        return t;
    }
}

