/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.services;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.petalslink.dsb.jbi.se.wsn.api.NotificationService;
import org.petalslink.dsb.jbi.se.wsn.api.Topic;
import org.petalslink.dsb.jbi.se.wsn.api.WSNException;
import org.w3c.dom.Document;

public class NotificationServiceImpl
implements NotificationService {
    private NotificationEngine engine;
    private Logger logger;

    public NotificationServiceImpl(NotificationEngine engine, Logger logger) {
        this.engine = engine;
        this.logger = logger;
    }

    public void notify(Topic topic, String message) throws WSNException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Notify on topic " + topic);
        }
        if (topic == null || message == null) {
            throw new WSNException("Null topic or message is not allowed");
        }
        QName t = new QName(topic.ns, topic.name, topic.prefix);
        Document document = null;
        try {
            document = XMLHelper.createDocumentFromString((String)message);
        }
        catch (Exception e) {
            String error = "Can not create a XML document from input message";
            this.logger.warning("Can not create a XML document from input message");
            throw new WSNException("Can not create a XML document from input message");
        }
        this.engine.notify(t, document);
    }
}

