/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.engines;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationProducerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyValueChangeNotificationType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopDatatypeUtils;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NoCurrentMessageOnTopicFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WsnbTopicManagerBadUsageException;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfrp.services.faults.InvalidResourcePropertyQNameFault;
import com.ebmwebsourcing.wsstar.wsrfrp.services.faults.UnableToModifyResourcePropertyFault;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationProducerEngine
implements INotificationProducer,
INotificationProducerRP {
    protected Logger logger;
    protected String wsnProducerEndpoint = "";
    protected QName wsnProducerService = null;
    protected QName wsnProducerInterface = null;
    protected NotificationProducerRP actorAsRP = null;
    protected TopicNamespaceType topicNSForRPChangeValueNotif = null;
    protected String associatedNSPrefix = null;
    protected TopicsManagerEngine topicsManager;
    protected SubscriptionManagerEngine subscriptionManagerService;
    protected Map<QName, List<NotificationMessageHolderType.Message>> currentMessages = null;
    protected ITransporterForWsnbPublisher notificationSender = null;

    public NotificationProducerEngine(Logger logger, TopicsManagerEngine topicsManagerEngine, SubscriptionManagerEngine subscriptionManagerEngine, boolean bl, TopicSetType topicSetType, TopicNamespaceType topicNamespaceType, String string, ITransporterForWsnbPublisher iTransporterForWsnbPublisher) throws WsnbException {
        this.logger = logger;
        this.topicsManager = topicsManagerEngine;
        this.subscriptionManagerService = subscriptionManagerEngine;
        this.topicNSForRPChangeValueNotif = topicNamespaceType;
        this.associatedNSPrefix = string;
        this.notificationSender = iTransporterForWsnbPublisher;
        this.initActorAsRPAndAttributes(bl, topicSetType);
    }

    public NotificationProducerEngine(Logger logger, SubscriptionManagerEngine subscriptionManagerEngine, boolean bl, TopicSetType topicSetType, TopicNamespaceType topicNamespaceType, String string, ITransporterForWsnbPublisher iTransporterForWsnbPublisher) throws WsnbException {
        this.logger = logger;
        this.subscriptionManagerService = subscriptionManagerEngine;
        this.topicNSForRPChangeValueNotif = topicNamespaceType;
        this.associatedNSPrefix = string;
        this.notificationSender = iTransporterForWsnbPublisher;
        this.initActorAsRPAndAttributes(bl, topicSetType);
    }

    public NotificationProducerEngine(boolean bl, TopicSetType topicSetType, TopicNamespaceType topicNamespaceType, String string, ITransporterForWsnbPublisher iTransporterForWsnbPublisher) throws WsnbException {
        this.topicNSForRPChangeValueNotif = topicNamespaceType;
        this.associatedNSPrefix = string;
        this.notificationSender = iTransporterForWsnbPublisher;
        this.initActorAsRPAndAttributes(bl, topicSetType);
    }

    protected void initActorAsRPAndAttributes(boolean bl, TopicSetType topicSetType) throws WsnbException {
        this.actorAsRP = RefinedWsnbFactory.getInstance().createNotificationProducerRP();
        this.actorAsRP.setFixedTopicSet(Boolean.valueOf(bl));
        TopicSetType topicSetType2 = topicSetType;
        if (!bl) {
            try {
                topicSetType2 = WstopDatatypeUtils.addTopicsFromTopicNamespaceToTopicSet((TopicSetType)topicSetType, (TopicNamespaceType)this.topicNSForRPChangeValueNotif, (String)this.associatedNSPrefix);
            }
            catch (WstopException wstopException) {
                throw new WsnbException((Throwable)wstopException);
            }
        }
        try {
            Document document = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(topicSetType2);
        }
        catch (WstopException wstopException) {
            wstopException.printStackTrace();
        }
        this.actorAsRP.setTopicSet(topicSetType2);
        this.currentMessages = new ConcurrentHashMap<QName, List<NotificationMessageHolderType.Message>>();
    }

    public void setNotificationProducerEdp(String string) {
        this.wsnProducerEndpoint = string;
    }

    public String getNotificationProducerEdp() {
        return this.wsnProducerEndpoint;
    }

    public void setNotificationProducerService(QName qName) {
        this.wsnProducerService = qName;
    }

    public QName getNotificationProducerService() {
        return this.wsnProducerService;
    }

    public void setNotificationProducerInterface(QName qName) {
        this.wsnProducerInterface = qName;
    }

    public QName getNotificationProducerInterfaceQName() {
        return this.wsnProducerInterface != null ? this.wsnProducerInterface : WsnbConstants.NOTIFICATION_PRODUCER_INTERFACE;
    }

    public NotificationProducerRP getActorAsRP() {
        return this.actorAsRP;
    }

    public TopicsManagerEngine getTopicsMgr() {
        return this.topicsManager;
    }

    public void setTopicsMgr(TopicsManagerEngine topicsManagerEngine) {
        this.topicsManager = topicsManagerEngine;
    }

    public SubscriptionManagerEngine getSubsMgr() {
        return this.subscriptionManagerService;
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessage) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"GetCurrentMessage\" request ...");
        if (this.topicsManager == null) {
            throw new WsnbTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        GetCurrentMessageResponse getCurrentMessageResponse = null;
        TopicExpressionType topicExpressionType = getCurrentMessage.getTopic();
        int n = topicExpressionType.getContent().indexOf(":");
        QName qName = new QName(((QName)topicExpressionType.getTopicNamespaces().get(0)).getNamespaceURI(), topicExpressionType.getContent().substring(n) + 1);
        List<NotificationMessageHolderType.Message> list = this.currentMessages.get(qName);
        if (list != null && list.size() > 0) {
            getCurrentMessageResponse = RefinedWsnbFactory.getInstance().createGetCurrentMessageResponse(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                getCurrentMessageResponse.addCurrentMessage(list.get(i));
            }
        } else {
            try {
                throw new NoCurrentMessageOnTopicFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The topic referenced in the GetCurrentMessage message does not have any pending messages.");
            }
            catch (WsrfbfException wsrfbfException) {
                throw new WsnbException((Throwable)wsrfbfException);
            }
        }
        return getCurrentMessageResponse;
    }

    public void setCurrentMessage(TopicExpressionType topicExpressionType, NotificationMessageHolderType.Message message, boolean bl) throws WsnbException, AbsWSStarFault {
        int n = topicExpressionType.getContent().indexOf(":");
        QName qName = new QName(((QName)topicExpressionType.getTopicNamespaces().get(0)).getNamespaceURI(), topicExpressionType.getContent().substring(n) + 1);
        List<NotificationMessageHolderType.Message> list = this.currentMessages.get(qName);
        if (list == null) {
            list = new ArrayList<NotificationMessageHolderType.Message>();
            this.currentMessages.put(qName, list);
        } else if (!bl) {
            list.clear();
        }
        list.add(message);
    }

    public SubscribeResponse subscribe(Subscribe subscribe) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Subscribe\" request ...");
        if (this.topicsManager == null) {
            throw new WsnbTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        SubscribeResponse subscribeResponse = null;
        List list = subscribe.getFilter().getTopicExpressions();
        try {
            Object object2;
            String string = UUID.randomUUID().toString();
            ArrayList<TopicExpressionType> arrayList = new ArrayList<TopicExpressionType>();
            Document document = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(this.actorAsRP.getTopicSet());
            for (Object object2 : list) {
                List<TopicExpressionType> list2 = this.topicsManager.getTopicsAsConcreteTopExpr((TopicExpressionType)object2, document);
                if (list2.isEmpty()) {
                    throw new TopicNotSupportedFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The Subscribe message contained a TopicExpression filter that referenced a topic that was not supported by the NotificationProducer.");
                }
                arrayList.addAll(list2);
            }
            EndpointReferenceType endpointReferenceType = this.subscriptionManagerService.createAndStoreSubscriptionResource(string, arrayList, subscribe);
            subscribeResponse = RefinedWsnbFactory.getInstance().createSubscribeResponse(endpointReferenceType);
            subscribeResponse.setCurrentTime(new Date());
            object2 = this.subscriptionManagerService.getTerminationTimeOfSubscription(string);
            if (object2 != null) {
                subscribeResponse.setTerminationTime((Date)object2);
            }
        }
        catch (WstopException wstopException) {
            throw new WsnbException((Throwable)wstopException);
        }
        catch (WsrfbfException wsrfbfException) {
            throw new WsnbException((Throwable)wsrfbfException);
        }
        return subscribeResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResourcePropertyResponse getResourceProperty(QName qName) throws WsnbException, AbsWSStarFault {
        GetResourcePropertyResponse getResourcePropertyResponse = null;
        ArrayList<Element> arrayList = null;
        try {
            if (qName.equals(WstopConstants.TOPIC_SET_QNAME)) {
                TopicSetType topicSetType = this.actorAsRP.getTopicSet();
                if (topicSetType == null) throw this.createInvalidResourcePropertyQNameFault();
                arrayList = new ArrayList<Element>();
                arrayList.add(Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(topicSetType).getDocumentElement());
            } else if (qName.equals(WsnbConstants.FIXED_TOPIC_SET_QNAME)) {
                Boolean bl = this.actorAsRP.isFixedTopicSet();
                if (bl == null) throw this.createInvalidResourcePropertyQNameFault();
                arrayList = new ArrayList();
                arrayList.add(Wsnb4ServUtils.createPropertyAsElement(qName, bl.toString()));
            } else if (qName.equals(WsnbConstants.TOPIC_EXPRESSION_QNAME)) {
                List list = this.actorAsRP.getTopicExpressions();
                if (list == null) throw this.createInvalidResourcePropertyQNameFault();
                arrayList = new ArrayList();
                for (TopicExpressionType topicExpressionType : list) {
                    arrayList.add(Wsnb4ServUtils.getWsnbWriter().writeTopicExpressionTypeAsDOM(topicExpressionType).getDocumentElement());
                }
            } else if (qName.equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME)) {
                arrayList = new ArrayList();
                List list = this.actorAsRP.getTopicExpressionDialects();
                if (list == null) throw this.createInvalidResourcePropertyQNameFault();
                arrayList = new ArrayList();
                for (URI uRI : list) {
                    arrayList.add(Wsnb4ServUtils.createPropertyAsElement(qName, uRI.toString()));
                }
            }
            if (arrayList == null) {
                throw this.createInvalidResourcePropertyQNameFault();
            }
            getResourcePropertyResponse = RefinedWsrfrpFactory.getInstance().createGetResourcePropertyResponse();
            getResourcePropertyResponse.setPropertyValue(arrayList);
            return getResourcePropertyResponse;
        }
        catch (WsrfrpException wsrfrpException) {
            throw new WsnbException((Throwable)wsrfrpException);
        }
        catch (WstopException wstopException) {
            throw new WsnbException((Throwable)wstopException);
        }
    }

    private InvalidResourcePropertyQNameFault createInvalidResourcePropertyQNameFault() throws WsnbException {
        try {
            return new InvalidResourcePropertyQNameFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message");
        }
        catch (WsrfrpException wsrfrpException) {
            throw new WsnbException((Throwable)wsrfrpException);
        }
        catch (WsrfbfException wsrfbfException) {
            throw new WsnbException((Throwable)wsrfbfException);
        }
    }

    public UpdateResourcePropertiesResponse updateResourceProperties(UpdateResourceProperties updateResourceProperties) throws WsnbException, AbsWSStarFault {
        UpdateResourcePropertiesResponse updateResourcePropertiesResponse = null;
        try {
            UpdateType updateType = updateResourceProperties.getUpdate();
            List list = updateType.getUpdateContent();
            for (Element element : list) {
                Object object;
                if (element.getLocalName().equals(WsnbConstants.FIXED_TOPIC_SET_QNAME.getLocalPart()) && element.getNamespaceURI().equals(WsnbConstants.FIXED_TOPIC_SET_QNAME.getNamespaceURI())) {
                    this.actorAsRP.setFixedTopicSet(new Boolean(element.getTextContent()));
                    continue;
                }
                if (element.getLocalName().equals(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart()) && element.getNamespaceURI().equals(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI())) {
                    object = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", object);
                }
                if (element.getLocalName().equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME.getLocalPart()) && element.getNamespaceURI().equals(WsnbConstants.TOPIC_EXPRESSION_DIALECT_QNAME.getNamespaceURI())) {
                    object = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", object);
                }
                if (element.getLocalName().equals(WstopConstants.TOPIC_SET_QNAME.getLocalPart()) && element.getNamespaceURI().equals(WstopConstants.TOPIC_SET_QNAME.getNamespaceURI())) {
                    if (!this.actorAsRP.isFixedTopicSet().booleanValue()) {
                        object = element.getOwnerDocument();
                        TopicSetType topicSetType = Wsnb4ServUtils.getWstopReader().readTopicSetType((Document)object);
                        this.actorAsRP.setTopicSet(topicSetType);
                        this.notifyTopicSetResourceModification(topicSetType, this.actorAsRP.getTopicSet());
                        List<String> list2 = this.subscriptionManagerService.lookForSubscriptionToTerminate((Document)object, this.topicsManager);
                        for (String string : list2) {
                            this.subscriptionManagerService.terminateSubscription(string);
                        }
                        continue;
                    }
                    object = RefinedWsrfrpFactory.getInstance().createResourcePropertyChangeFailureType(true);
                    throw new UnableToModifyResourcePropertyFault(WsrfrpFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The QName in the request message did not correspond to a resource property element of the WS-Resource referred to in the request message", object);
                }
                throw this.createInvalidResourcePropertyQNameFault();
            }
            updateResourcePropertiesResponse = RefinedWsrfrpFactory.getInstance().createUpdateResourcePropertiesResponse();
        }
        catch (WsrfrpException wsrfrpException) {
            throw new WsnbException((Throwable)wsrfrpException);
        }
        catch (WstopException wstopException) {
            throw new WsnbException((Throwable)wstopException);
        }
        catch (WsrfbfException wsrfbfException) {
            throw new WsnbException((Throwable)wsrfbfException);
        }
        return updateResourcePropertiesResponse;
    }

    private void notifyTopicSetResourceModification(TopicSetType topicSetType, TopicSetType topicSetType2) throws WsnbException {
        if (this.notificationSender != null) {
            try {
                Element element = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(topicSetType).getDocumentElement();
                Element element2 = Wsnb4ServUtils.getWstopWriter().writeTopicSetTypeAsDOM(topicSetType2).getDocumentElement();
                ResourcePropertyValueChangeNotificationType.NewValues newValues = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationTypeNewValues(element);
                ResourcePropertyValueChangeNotificationType.OldValues oldValues = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationTypeOldValues(element2);
                ResourcePropertyValueChangeNotificationType resourcePropertyValueChangeNotificationType = RefinedWsrfrpFactory.getInstance().createResourcePropertyValueChangeNotificationType(newValues);
                resourcePropertyValueChangeNotificationType.setOldValues(oldValues);
                Document document = Wsnb4ServUtils.getWsrfrpWriter().writeResourcePropertyValueChangeNotificationTypeAsDOM(resourcePropertyValueChangeNotificationType);
                NotificationMessageHolderType.Message message = RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(document.getDocumentElement());
                NotificationMessageHolderType notificationMessageHolderType = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(message);
                TopicExpressionType topicExpressionType = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.SIMPLE_TOPIC_EXPRESSION_DIALECT_URI);
                topicExpressionType.addTopicNamespace(this.associatedNSPrefix, this.topicNSForRPChangeValueNotif.getNamespace());
                topicExpressionType.setContent(this.associatedNSPrefix + ":" + "TopicSet");
                notificationMessageHolderType.setTopic(topicExpressionType);
                Notify notify = RefinedWsnbFactory.getInstance().createNotify(notificationMessageHolderType);
                List<String> list = this.subscriptionManagerService.getStoredSubscriptionUuids();
                ArrayList<EndpointReferenceType> arrayList = new ArrayList<EndpointReferenceType>();
                EndpointReferenceType endpointReferenceType = null;
                for (String string : list) {
                    endpointReferenceType = this.subscriptionManagerService.getConsumerEdpRefOfSubscription(string);
                    if (!this.mustBeNotified(endpointReferenceType, arrayList)) continue;
                    this.notificationSender.sendNotifyRequest(endpointReferenceType, notify);
                    arrayList.add(endpointReferenceType);
                }
            }
            catch (WsrfrpException wsrfrpException) {
                throw new WsnbException((Throwable)wsrfrpException);
            }
            catch (WstopException wstopException) {
                throw new WsnbException((Throwable)wstopException);
            }
        }
    }

    private boolean mustBeNotified(EndpointReferenceType endpointReferenceType, List<EndpointReferenceType> list) {
        boolean bl = true;
        return bl;
    }

    private void updateStoredCurrentMsgList(Document document) throws WsnbException {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        TopicExpressionType topicExpressionType = null;
        int n = -1;
        String string = null;
        for (QName qName : this.currentMessages.keySet()) {
            string = qName.getLocalPart();
            n = string.indexOf(":");
            topicExpressionType = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            try {
                topicExpressionType.addTopicNamespace(string.substring(0, n), new URI(qName.getNamespaceURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WsnbException((Throwable)uRISyntaxException);
            }
            topicExpressionType.setContent(string);
            if (this.topicsManager.isSupportedTopic(topicExpressionType, document)) continue;
            arrayList.add(qName);
        }
        for (QName qName : arrayList) {
            this.currentMessages.remove(qName);
        }
    }
}

