/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.engines;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.utils.WsrfrException;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTimeResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.ISubscriptionManager;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnableToDestroySubscriptionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.persistence.WsnbPersistence;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.wsresources.WsnSubscription;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionManagerEngine
implements ISubscriptionManager {
    protected Logger logger;
    protected Map<String, WsnSubscription> subscriptions;
    protected Map<QName, List<String>> uuidsPerTopics;
    protected WsnbPersistence persistenceMgr;
    protected String subscriptionsManagerEdp = "";
    protected QName subscriptionsManagerService = null;
    protected QName subscriptionsManagerInterface = null;
    protected String targetSubscriptionResourceUuid = "";
    protected ITransporterForWsnbPublisher notificationSender = null;

    public SubscriptionManagerEngine(Logger logger, WsnbPersistence wsnbPersistence, ITransporterForWsnbPublisher iTransporterForWsnbPublisher) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, WsnSubscription>();
        this.uuidsPerTopics = new ConcurrentHashMap<QName, List<String>>();
        this.persistenceMgr = wsnbPersistence;
        this.notificationSender = iTransporterForWsnbPublisher;
    }

    public SubscriptionManagerEngine(Logger logger) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, WsnSubscription>();
        this.uuidsPerTopics = new ConcurrentHashMap<QName, List<String>>();
        this.persistenceMgr = null;
    }

    public String getSubscriptionsManagerEdp() {
        return this.subscriptionsManagerEdp;
    }

    public void setSubscriptionsManagerEdp(String string) {
        this.subscriptionsManagerEdp = string;
    }

    public QName getSubscriptionsManagerService() {
        return this.subscriptionsManagerService;
    }

    public void setSubscriptionsManagerService(QName qName) {
        this.subscriptionsManagerService = qName;
    }

    public QName getSubscriptionsManagerInterface() {
        return this.subscriptionsManagerInterface != null ? this.subscriptionsManagerInterface : WsnbConstants.SUBSCRIPTION_MANAGER_INTERFACE;
    }

    public void setSubscriptionsManagerInterface(QName qName) {
        this.subscriptionsManagerInterface = qName;
    }

    public List<String> getStoredSubscriptionUuids() {
        return new CopyOnWriteArrayList<String>(this.subscriptions.keySet());
    }

    public void setTargetSubscriptionResourceUuid(String string) {
        this.targetSubscriptionResourceUuid = string;
    }

    public ITransporterForWsnbPublisher getNotificationSender() {
        return this.notificationSender;
    }

    public void setNotificationSender(ITransporterForWsnbPublisher iTransporterForWsnbPublisher) {
        this.notificationSender = iTransporterForWsnbPublisher;
    }

    private void throwSubscriptionUuidNotSetException(String string) throws WsnbException, ResourceUnknownFault {
        this.logger.log(Level.WARNING, "The target Subscription Uuid value is not set.\nYou must first call \"SubscriptionManagerEngine.setTargetSubscriptionResourceUuid(String uuid)\" method before \"" + string + "(...)\" method !!");
        try {
            throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
        }
        catch (WsrfrException wsrfrException) {
            throw new WsnbException((Throwable)wsrfrException);
        }
        catch (WsrfbfException wsrfbfException) {
            throw new WsnbException((Throwable)wsrfbfException);
        }
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribe) throws WsnbException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Unsubscribe\" request ...");
        try {
            Object object;
            if ((this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) && unsubscribe.getAny().size() > 0) {
                if (unsubscribe.getAny().get(0) instanceof JAXBElement) {
                    object = (JAXBElement)unsubscribe.getAny().get(0);
                    if (object.getValue() instanceof EJaxbEndpointReferenceType) {
                        String string;
                        EJaxbEndpointReferenceType eJaxbEndpointReferenceType = (EJaxbEndpointReferenceType)object.getValue();
                        Element element = (Element)eJaxbEndpointReferenceType.getReferenceParameters().getAny().get(0);
                        this.targetSubscriptionResourceUuid = string = element.getFirstChild().getNodeValue();
                    }
                } else if (unsubscribe.getAny().get(0) instanceof Element && (object = (Element)unsubscribe.getAny().get(0)).getLocalName().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getLocalPart()) && object.getNamespaceURI().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getNamespaceURI())) {
                    this.targetSubscriptionResourceUuid = object.getTextContent();
                }
            }
            if (this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) {
                this.throwSubscriptionUuidNotSetException("unsubscribe");
            }
            object = null;
            if (this.subscriptions.containsKey(this.targetSubscriptionResourceUuid)) {
                object = this.subscriptions.remove(this.targetSubscriptionResourceUuid);
                if (this.subscriptions.containsKey(this.targetSubscriptionResourceUuid)) {
                    try {
                        throw new UnableToDestroySubscriptionFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager was unable to destroy the Subscription resource for some reason.");
                    }
                    catch (WsrfbfException wsrfbfException) {
                        throw new WsnbException((Throwable)wsrfbfException);
                    }
                }
                this.removeUuidFromUuidsPerTopic(this.targetSubscriptionResourceUuid);
                if (this.persistenceMgr != null) {
                    this.persistenceMgr.removeSubscription(this.targetSubscriptionResourceUuid);
                }
            } else {
                try {
                    throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
                }
                catch (WsrfrException wsrfrException) {
                    throw new WsnbException((Throwable)wsrfrException);
                }
                catch (WsrfbfException wsrfbfException) {
                    throw new WsnbException((Throwable)wsrfbfException);
                }
            }
            ((WsnSubscription)object).destroy(RefinedWsrfrlFactory.getInstance().createDestroy());
        }
        catch (WsrfrlException wsrfrlException) {
            throw new WsnbException((Throwable)wsrfrlException);
        }
        this.targetSubscriptionResourceUuid = "";
        return RefinedWsnbFactory.getInstance().createUnsubscribeResponse();
    }

    private void removeUuidFromUuidsPerTopic(String string) {
        List<String> list2 = null;
        for (List<String> list2 : this.uuidsPerTopics.values()) {
            list2.remove(string);
        }
    }

    public RenewResponse renew(Renew renew) throws WsnbException, AbsWSStarFault {
        SetTerminationTimeResponse setTerminationTimeResponse;
        this.logger.log(Level.FINE, "performs a \"Renew\" request ...");
        if (this.targetSubscriptionResourceUuid == null || this.targetSubscriptionResourceUuid.equals("")) {
            this.throwSubscriptionUuidNotSetException("renew");
        }
        RenewResponse renewResponse = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(this.targetSubscriptionResourceUuid);
        if (wsnSubscription == null) {
            try {
                throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
            catch (WsrfrException wsrfrException) {
                throw new WsnbException((Throwable)wsrfrException);
            }
            catch (WsrfbfException wsrfbfException) {
                throw new WsnbException((Throwable)wsrfbfException);
            }
        }
        Object object = renew.getTerminationTime();
        SetTerminationTime setTerminationTime = null;
        try {
            setTerminationTime = object instanceof Duration ? RefinedWsrfrlFactory.getInstance().createSetTerminationTime((Duration)object) : RefinedWsrfrlFactory.getInstance().createSetTerminationTime((Date)object);
        }
        catch (WsrfrlException wsrfrlException) {
            throw new WsnbException((Throwable)wsrfrlException);
        }
        try {
            setTerminationTimeResponse = wsnSubscription.setTerminationTime(setTerminationTime);
        }
        catch (WsrfrlException wsrfrlException) {
            throw new WsnbException((Throwable)wsrfrlException);
        }
        renewResponse = RefinedWsnbFactory.getInstance().createRenewResponse(setTerminationTimeResponse.getNewTerminationTime());
        renewResponse.setCurrentTime(setTerminationTimeResponse.getCurrentTime());
        this.targetSubscriptionResourceUuid = "";
        return renewResponse;
    }

    public EndpointReferenceType createAndStoreSubscriptionResource(String string, List<TopicExpressionType> list, Subscribe subscribe) throws WsnbException, AbsWSStarFault {
        WsnSubscription wsnSubscription = null;
        try {
            URI uRI = new URI(this.subscriptionsManagerService.getNamespaceURI() + "::" + this.subscriptionsManagerService.getLocalPart() + "@" + this.subscriptionsManagerEdp);
            wsnSubscription = new WsnSubscription(this.logger, uRI, string, subscribe, this.notificationSender);
            wsnSubscription.setAssociatedTopicExprs(list);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WsnbException((Throwable)uRISyntaxException);
        }
        this.subscriptions.put(string, wsnSubscription);
        if (this.persistenceMgr != null) {
            this.persistenceMgr.persist(wsnSubscription.getSubscriptionResource(), string);
        }
        this.storeUuidInUuidsPerTopicsList(string, list);
        return wsnSubscription.getSubscriptionReference();
    }

    private void storeUuidInUuidsPerTopicsList(String string, List<TopicExpressionType> list) {
        QName qName = null;
        List<String> list2 = null;
        for (TopicExpressionType topicExpressionType : list) {
            qName = topicExpressionType.getTopicNamespaces().size() > 0 ? new QName(((QName)topicExpressionType.getTopicNamespaces().get(0)).getNamespaceURI(), topicExpressionType.getContent()) : new QName(topicExpressionType.getContent());
            if (this.uuidsPerTopics.containsKey(qName)) {
                list2 = this.uuidsPerTopics.get(qName);
                if (list2.contains(string)) continue;
                list2.add(string);
                continue;
            }
            CopyOnWriteArrayList<String> copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
            copyOnWriteArrayList.add(string);
            this.uuidsPerTopics.put(qName, copyOnWriteArrayList);
        }
    }

    public List<String> removeAllSubscription() throws WsnbException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.subscriptions.keySet());
        for (String string : this.subscriptions.keySet()) {
            if (this.persistenceMgr == null) continue;
            this.persistenceMgr.removeSubscription(string);
        }
        this.subscriptions.clear();
        this.uuidsPerTopics.clear();
        return arrayList;
    }

    public EndpointReferenceType getConsumerEdpRefOfSubscription(String string) throws WsnbException {
        EndpointReferenceType endpointReferenceType = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null) {
            endpointReferenceType = wsnSubscription.getConsumerEdpRef();
        }
        return endpointReferenceType;
    }

    public EndpointReferenceType getSubscriptionRef(String string) throws WsnbException {
        EndpointReferenceType endpointReferenceType = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null) {
            endpointReferenceType = wsnSubscription.getSubscriptionReference();
        }
        return endpointReferenceType;
    }

    public List<TopicExpressionType> getTopicExpressionOfSubscription(String string) throws WsnbException {
        List<TopicExpressionType> list = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null) {
            list = wsnSubscription.getTopicExpressionOfSubscription();
        }
        return list;
    }

    public FilterType getFilterOfSubscription(String string) throws WsnbException {
        FilterType filterType = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null) {
            filterType = wsnSubscription.getFilterOfSubscription();
        }
        return filterType;
    }

    public SubscriptionPolicyType getPolicyOfSubscription(String string) throws WsnbException {
        SubscriptionPolicyType subscriptionPolicyType = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null) {
            subscriptionPolicyType = wsnSubscription.getPolicyOfSubscription();
        }
        return subscriptionPolicyType;
    }

    public Date getTerminationTimeOfSubscription(String string) throws WsnbException {
        Date date = null;
        WsnSubscription wsnSubscription = this.subscriptions.get(string);
        if (wsnSubscription != null && wsnSubscription.getTerminationTime() != null) {
            date = wsnSubscription.getTerminationTime().getValue();
        }
        return date;
    }

    public void removeExpiredSubscription(String string) throws WsnbException {
        if (this.subscriptions.containsKey(string)) {
            this.subscriptions.remove(string);
            this.removeUuidFromUuidsPerTopic(string);
            if (this.persistenceMgr != null) {
                this.persistenceMgr.removeSubscription(string);
            }
        }
    }

    public void restorePersistedSubscriptions(TopicsManagerEngine topicsManagerEngine, Document document) throws WsnbException, AbsWSStarFault {
        if (this.persistenceMgr != null) {
            Map<String, SubscriptionManagerRP> map = this.persistenceMgr.getSubscriptionsToRestore();
            Set<String> set = map.keySet();
            SubscriptionManagerRP subscriptionManagerRP = null;
            URI uRI = null;
            List list = null;
            WsnSubscription wsnSubscription = null;
            CopyOnWriteArrayList<TopicExpressionType> copyOnWriteArrayList = null;
            for (String string : set) {
                try {
                    uRI = new URI(this.subscriptionsManagerService.getNamespaceURI() + "::" + this.subscriptionsManagerService.getLocalPart() + "@" + this.subscriptionsManagerEdp);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new WsnbException((Throwable)uRISyntaxException);
                }
                subscriptionManagerRP = map.get(string);
                wsnSubscription = new WsnSubscription(this.logger, uRI, string, subscriptionManagerRP);
                list = subscriptionManagerRP.getFilter().getTopicExpressions();
                copyOnWriteArrayList = new CopyOnWriteArrayList<TopicExpressionType>();
                for (TopicExpressionType topicExpressionType : list) {
                    copyOnWriteArrayList.addAll(topicsManagerEngine.getTopicsAsConcreteTopExpr(topicExpressionType, document));
                }
                wsnSubscription.setAssociatedTopicExprs(copyOnWriteArrayList);
                this.subscriptions.put(string, wsnSubscription);
                this.storeUuidInUuidsPerTopicsList(string, copyOnWriteArrayList);
            }
        }
    }

    public List<String> lookForSubscriptionToTerminate(Document document, TopicsManagerEngine topicsManagerEngine) throws WsnbException {
        CopyOnWriteArrayList<String> copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
        TopicExpressionType topicExpressionType = null;
        int n = -1;
        String string = null;
        WsnSubscription wsnSubscription = null;
        for (QName qName : this.uuidsPerTopics.keySet()) {
            string = qName.getLocalPart();
            n = string.indexOf(":");
            topicExpressionType = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            try {
                if (n > 0) {
                    topicExpressionType.addTopicNamespace(string.substring(0, n), new URI(qName.getNamespaceURI()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WsnbException((Throwable)uRISyntaxException);
            }
            topicExpressionType.setContent(string);
            if (topicsManagerEngine.isSupportedTopic(topicExpressionType, document)) continue;
            List<String> list = this.uuidsPerTopics.get(qName);
            for (String string2 : list) {
                wsnSubscription = this.subscriptions.get(string2);
                if (wsnSubscription == null || wsnSubscription.removeAssociatedTopicExpr(topicExpressionType) > 0 || copyOnWriteArrayList.contains(string2)) continue;
                copyOnWriteArrayList.add(string2);
            }
        }
        return copyOnWriteArrayList;
    }

    public void terminateSubscription(String string) throws WsnbException, AbsWSStarFault {
        WsnSubscription wsnSubscription = this.subscriptions.remove(string);
        List<TopicExpressionType> list = wsnSubscription.getAssociatedTopicExprs();
        List<String> list2 = null;
        for (TopicExpressionType topicExpressionType : list) {
            list2 = this.uuidsPerTopics.get(topicExpressionType);
            if (list2 == null) continue;
            list2.remove(string);
        }
        try {
            wsnSubscription.destroy(RefinedWsrfrlFactory.getInstance().createDestroy());
        }
        catch (WsrfrlException wsrfrlException) {
            throw new WsnbException((Throwable)wsrfrlException);
        }
        wsnSubscription = null;
    }

    public void deleteAllForTopic(QName qName) {
        List<String> list = this.uuidsPerTopics.get(qName);
        for (String string : list) {
            try {
                this.removeExpiredSubscription(string);
            }
            catch (WsnbException wsnbException) {
                wsnbException.printStackTrace();
            }
        }
        this.uuidsPerTopics.remove(qName);
    }
}

