/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.persistence;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnbPersistence {
    private File subscriptions_folder = null;

    public WsnbPersistence(File file) {
        if (file == null) {
            throw new NullPointerException("Persistence folder must not be null");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        this.subscriptions_folder = file;
    }

    public void persist(SubscriptionManagerRP subscriptionManagerRP, String string) throws WsnbException {
        RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscriptionManagerRPToFilesystem(subscriptionManagerRP, this.subscriptions_folder.getAbsoluteFile() + File.separator + string);
    }

    public Map<String, SubscriptionManagerRP> getSubscriptionsToRestore() throws WsnbException {
        ConcurrentHashMap<String, SubscriptionManagerRP> concurrentHashMap = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        if (this.subscriptions_folder.exists()) {
            File[] fileArray = this.subscriptions_folder.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                concurrentHashMap.put(fileArray[i].getName(), RefinedWsnbFactory.getInstance().getWsnbReader().readSubscriptionManagerRP(fileArray[i]));
            }
        }
        return concurrentHashMap;
    }

    public void removeSubscription(String string) throws WsnbException {
        File file = new File(this.subscriptions_folder, string);
        if (file.exists()) {
            file.delete();
        }
    }
}

