/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.topic;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.XPathDOMAnalyzer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicsManagerEngine {
    private static final String FLAG_TOPIC_EQUAL_TRUE = "[@wstop:topic='true']";
    private final XPathDOMAnalyzer xpathAnalyser = new XPathDOMAnalyzer();

    public List<TopicExpressionType> getTopicsAsConcreteTopExpr(TopicExpressionType topicExpressionType, Document document) throws WsnbException {
        Object object;
        CopyOnWriteArrayList<TopicExpressionType> copyOnWriteArrayList = new CopyOnWriteArrayList<TopicExpressionType>();
        List list = topicExpressionType.getTopicNamespaces();
        String string = topicExpressionType.getContent();
        QName qName = QName.valueOf(string);
        if (qName.getNamespaceURI() != null && qName.getNamespaceURI().trim().length() > 0) {
            string = qName.getLocalPart() + ":" + qName.getLocalPart();
            list.add(new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart()));
        } else if (string.contains(":")) {
            object = string.split(":")[0];
            String string2 = string.split(":")[1];
            boolean bl = false;
            for (QName qName2 : list) {
                if (!qName2.getLocalPart().equals(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = string2;
            }
        }
        object = this.lookForNodes(string, list, document);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node.getNodeType() != 1) continue;
            copyOnWriteArrayList.add(this.getConcreteTopicExpression(node, list));
        }
        return copyOnWriteArrayList;
    }

    private NodeList lookForNodes(String string, List<QName> list, Document document) throws WsnbException {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (QName qName : list) {
            concurrentHashMap.put(qName.getLocalPart(), qName.getNamespaceURI());
        }
        concurrentHashMap.put("wstop", "http://docs.oasis-open.org/wsn/t-1");
        String string2 = "//" + string + (!string.endsWith(FLAG_TOPIC_EQUAL_TRUE) ? FLAG_TOPIC_EQUAL_TRUE : "");
        return this.xpathAnalyser.evaluate(string2, document, concurrentHashMap);
    }

    private TopicExpressionType getConcreteTopicExpression(Node node, List<QName> list) throws WsnbException {
        TopicExpressionType topicExpressionType = null;
        Element element = (Element)node;
        Node node2 = node;
        String string = "";
        do {
            string = element.getNodeName() + (string.length() > 0 ? "/" : "") + string;
            node2 = node2.getParentNode();
            Element element2 = element = node2 != null ? (Element)node2 : null;
        } while (element != null && !element.getNodeName().equals(WstopConstants.TOPIC_SET_QNAME.getPrefix() + ":" + WstopConstants.TOPIC_SET_QNAME.getLocalPart()));
        topicExpressionType = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
        topicExpressionType.setContent(string);
        try {
            for (QName qName : list) {
                topicExpressionType.addTopicNamespace(qName.getLocalPart(), new URI(qName.getNamespaceURI()));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WsnbException((Throwable)uRISyntaxException);
        }
        return topicExpressionType;
    }

    public boolean isSupportedTopic(TopicExpressionType topicExpressionType, Document document) throws WsnbException {
        boolean bl = false;
        if (topicExpressionType.getDialect().equals(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI)) {
            NodeList nodeList = this.lookForNodes(topicExpressionType.getContent(), topicExpressionType.getTopicNamespaces(), document);
            bl = nodeList != null && nodeList.getLength() == 1;
        }
        return bl;
    }
}

