/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.wsresources;

import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.EndpointReference;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WSNUtil;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.utils.WsrfrException;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.CurrentTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.Destroy;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.DestroyResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ScheduledResourceTerminationRP;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTimeResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationNotification;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnacceptableInitialTerminationTimeFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.wsrfrl.services.IImmediateResourceTermination;
import com.ebmwebsourcing.wsstar.wsrfrl.services.IScheduledResourceTermination;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnSubscription
implements IImmediateResourceTermination,
IScheduledResourceTermination {
    private static final String IMMEDIAT_TERMINAISON_REASON = "The \"Subscription\" resource have been detroy for some reason (Reloated Topic no longer supported, ...)";
    protected Logger logger;
    private SubscriptionManagerRP subscriptionResource = null;
    private EndpointReferenceType subscriptionReference = null;
    private ScheduledResourceTerminationRP terminationRP = null;
    protected String wsResourceEdpBase = "";
    protected QName wsResourceService = null;
    protected QName wsResourceInterface = null;
    protected List<TopicExpressionType> concreteTopExprs = null;
    protected ITransporterForWsnbPublisher transporter = null;

    public WsnSubscription(Logger logger, URI uRI, String string, Subscribe subscribe, ITransporterForWsnbPublisher iTransporterForWsnbPublisher) throws WsnbException, AbsWSStarFault {
        this.logger = logger;
        try {
            Object object;
            this.transporter = iTransporterForWsnbPublisher;
            this.subscriptionReference = (EndpointReferenceType)WSNUtil.getInstance().getXmlObjectFactory().create(EndpointReference.class);
            Address address = (Address)WSNUtil.getInstance().getXmlObjectFactory().create(Address.class);
            address.setValue(uRI);
            this.subscriptionReference.setAddress(address);
            ReferenceParameters referenceParameters = (ReferenceParameters)WSNUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
            referenceParameters.addAny((Object)Wsnb4ServUtils.createSubscriptionIdAsReferenceParamElt(string));
            this.concreteTopExprs = new ArrayList<TopicExpressionType>();
            this.subscriptionReference.setReferenceParameters(referenceParameters);
            this.subscriptionResource = RefinedWsnbFactory.getInstance().createSubscriptionManagerRP(subscribe.getConsumerReference());
            FilterType filterType = subscribe.getFilter();
            if (filterType != null) {
                this.subscriptionResource.setFilter(filterType);
            }
            this.subscriptionResource.setCreationTime(new Date());
            SubscriptionPolicyType subscriptionPolicyType = subscribe.getSubscriptionPolicy();
            if (subscriptionPolicyType != null) {
                this.subscriptionResource.setSubscriptionPolicy(subscriptionPolicyType);
            }
            if ((object = subscribe.getInitialTerminationTime()) != null) {
                Duration duration;
                Date date = null;
                if (object instanceof Duration) {
                    duration = (Duration)object;
                    date = new Date();
                    duration.addTo(date);
                } else {
                    date = (Date)object;
                }
                if (!date.after(new Date())) {
                    try {
                        throw new UnacceptableInitialTerminationTimeFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The value of InitialTerminationTime specified in the Subscribe message was not\tacceptable to the NotificationProducer.");
                    }
                    catch (WsrfbfException wsrfbfException) {
                        new WsnbException((Throwable)wsrfbfException);
                    }
                }
                duration = RefinedWsrfrlFactory.getInstance().createCurrentTime(new Date());
                TerminationTime terminationTime = RefinedWsrfrlFactory.getInstance().createTerminationTime(date);
                this.terminationRP = RefinedWsrfrlFactory.getInstance().createScheduledResourceTerminationRP((CurrentTime)duration, terminationTime);
            }
        }
        catch (WsrfrlException wsrfrlException) {
            throw new WsnbException((Throwable)wsrfrlException);
        }
    }

    public WsnSubscription(Logger logger, URI uRI, String string, SubscriptionManagerRP subscriptionManagerRP) throws WsnbException {
        this.concreteTopExprs = new ArrayList<TopicExpressionType>();
        this.subscriptionResource = subscriptionManagerRP;
        this.subscriptionReference = (EndpointReferenceType)WSNUtil.getInstance().getXmlObjectFactory().create(EndpointReference.class);
        Address address = (Address)WSNUtil.getInstance().getXmlObjectFactory().create(Address.class);
        address.setValue(uRI);
        this.subscriptionReference.setAddress(address);
        ReferenceParameters referenceParameters = (ReferenceParameters)WSNUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
        referenceParameters.addAny((Object)Wsnb4ServUtils.createSubscriptionIdAsReferenceParamElt(string));
        this.subscriptionReference.setReferenceParameters(referenceParameters);
        this.logger = logger;
    }

    public String getWsResourceEdpBase() {
        return this.wsResourceEdpBase;
    }

    public void setWsResourceEdpBase(String string) {
        this.wsResourceEdpBase = string;
    }

    public QName getWsrfSubscriptionService() {
        return this.wsResourceService;
    }

    public void setWsrfSubscriptionService(QName qName) {
        this.wsResourceService = qName;
    }

    public QName getWsrfSubscriptionInterface() {
        return this.wsResourceInterface != null ? this.wsResourceInterface : WsnbConstants.SUBSCRIPTION_MANAGER_INTERFACE;
    }

    public void setWsrfSubscriptionInterface(QName qName) {
        this.wsResourceInterface = qName;
    }

    public EndpointReferenceType getSubscriptionReference() {
        return this.subscriptionReference;
    }

    public TerminationTime getTerminationTime() {
        if (this.terminationRP != null) {
            return this.terminationRP.getTerminationTime();
        }
        return null;
    }

    public SubscriptionManagerRP getSubscriptionResource() {
        return this.subscriptionResource;
    }

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime setTerminationTime) throws WsrfrlException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"SetTerminationTime\" request ...");
        SetTerminationTimeResponse setTerminationTimeResponse = null;
        if (this.subscriptionResource == null) {
            try {
                throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
            catch (WsrfrException wsrfrException) {
                throw new WsrfrlException((Throwable)wsrfrException);
            }
            catch (WsrfbfException wsrfbfException) {
                throw new WsrfrlException((Throwable)wsrfbfException);
            }
        }
        Object object = setTerminationTime.getRequestedTerminationTime() == null ? setTerminationTime.getRequestedLifetimeDuration() : setTerminationTime.getRequestedTerminationTime();
        Date date = new Date();
        Date date2 = null;
        if (object instanceof Duration) {
            ((Duration)object).addTo(date);
        } else {
            date2 = (Date)object;
        }
        this.terminationRP.getTerminationTime().setValue(date2);
        setTerminationTimeResponse = RefinedWsrfrlFactory.getInstance().createSetTerminationTimeResponse(date, date2);
        return setTerminationTimeResponse;
    }

    public DestroyResponse destroy(Destroy destroy) throws WsrfrlException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Destroy\" request ...");
        EndpointReferenceType endpointReferenceType = this.subscriptionResource.getConsumerReference();
        this.subscriptionResource = null;
        this.subscriptionReference = null;
        this.terminationRP = null;
        if (this.transporter != null) {
            TerminationNotification terminationNotification = RefinedWsrfrlFactory.getInstance().createTerminationNotification(new Date());
            terminationNotification.setTerminationReason((Object)Wsnb4ServUtils.createSimpleReasonElement(IMMEDIAT_TERMINAISON_REASON));
            try {
                Document document = Wsnb4ServUtils.getWsrfrlWriter().writeTerminationNotificationAsDOM(terminationNotification);
                NotificationMessageHolderType.Message message = RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(document.getDocumentElement());
                NotificationMessageHolderType notificationMessageHolderType = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(message);
                TopicExpressionType topicExpressionType = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.SIMPLE_TOPIC_EXPRESSION_DIALECT_URI);
                topicExpressionType.addTopicNamespace("wsrf-rl", new URI("http://docs.oasis-open.org/wsrf/rl-2"));
                topicExpressionType.setContent("wsrf-rl:ResourceTermination");
                notificationMessageHolderType.setTopic(topicExpressionType);
                Notify notify = RefinedWsnbFactory.getInstance().createNotify(notificationMessageHolderType);
                this.transporter.sendNotifyRequest(endpointReferenceType, notify);
            }
            catch (WsnbException wsnbException) {
                new WsnbException((Throwable)wsnbException);
            }
            catch (URISyntaxException uRISyntaxException) {
                new WsnbException((Throwable)uRISyntaxException);
            }
        }
        return RefinedWsrfrlFactory.getInstance().createDestroyResponse();
    }

    public EndpointReferenceType getConsumerEdpRef() throws WsnbException {
        return this.subscriptionResource.getConsumerReference();
    }

    public List<TopicExpressionType> getTopicExpressionOfSubscription() throws WsnbException {
        FilterType filterType = this.subscriptionResource.getFilter();
        return filterType != null ? filterType.getTopicExpressions() : null;
    }

    public FilterType getFilterOfSubscription() throws WsnbException {
        return this.subscriptionResource.getFilter();
    }

    public SubscriptionPolicyType getPolicyOfSubscription() throws WsnbException {
        return this.subscriptionResource.getSubscriptionPolicy();
    }

    public List<TopicExpressionType> getAssociatedTopicExprs() {
        return this.concreteTopExprs;
    }

    public void setAssociatedTopicExprs(List<TopicExpressionType> list) {
        this.concreteTopExprs.clear();
        this.concreteTopExprs.addAll(list);
    }

    public int removeAssociatedTopicExpr(TopicExpressionType topicExpressionType) {
        int n = this.concreteTopExprs.size();
        ArrayList<TopicExpressionType> arrayList = new ArrayList<TopicExpressionType>();
        String string = topicExpressionType.getContent();
        QName qName = (QName)topicExpressionType.getTopicNamespaces().get(0);
        for (TopicExpressionType topicExpressionType2 : this.concreteTopExprs) {
            if (!qName.equals(topicExpressionType2.getTopicNamespaces().get(0)) || !topicExpressionType2.getContent().startsWith(string)) continue;
            arrayList.add(topicExpressionType2);
        }
        for (TopicExpressionType topicExpressionType2 : arrayList) {
            this.concreteTopExprs.remove(topicExpressionType2);
        }
        n = this.concreteTopExprs.size();
        return n;
    }
}

