/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.dsb.wsn.component;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.xml.namespace.QName;
import org.ow2.play.dsb.wsn.component.TopicAwareService;
import org.ow2.play.governance.api.EventGovernance;
import org.ow2.play.governance.api.TopicAware;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.petalslink.dsb.jbi.se.wsn.TopicSetHelper;
import org.petalslink.dsb.notification.commons.SOAUtil;
import org.w3c.dom.Document;

public class Component
extends org.petalslink.dsb.jbi.se.wsn.Component {
    protected void initializeNotificationEngine() throws JBIException {
        Properties props = new Properties();
        try {
            props.load(Component.class.getClassLoader().getResourceAsStream("notification.cfg"));
        }
        catch (IOException e) {
            // empty catch block
        }
        Document topicsDOM = this.getTopicSet();
        if (topicsDOM == null) {
            this.getLogger().warning("Can not get a list of topics to use in the component!");
            topicsDOM = TopicSetHelper.getWSNDocument(new ArrayList());
        }
        Document tnsDOM = this.getTNS();
        String endpointName = props.getProperty("endpoint", "Endpoint");
        QName interfaceName = QName.valueOf(props.getProperty("interface", "{http://dsb.petalslink.com/notification}NotificationInterface"));
        QName serviceName = QName.valueOf(props.getProperty("service", "{http://dsb.petalslink.com/notification}NotificationService"));
        if (this.engine == null) {
            this.engine = new NotificationEngine(this.getLogger(), serviceName, interfaceName, endpointName, this.getClient());
        }
        this.engine.init(topicsDOM, tnsDOM);
    }

    protected Document getTNS() throws JBIException {
        URL tns = Component.class.getClassLoader().getResource("topics/business-topicns-rpupdate.xml");
        if (tns == null) {
            throw new JBIException("Can not find the notification topicnamespace configuration file");
        }
        try {
            return SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(tns.openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
    }

    public Document getTopicSet() {
        Document result = null;
        Properties play = new Properties();
        try {
            play.load(Component.class.getClassLoader().getResourceAsStream("play.cfg"));
        }
        catch (Exception e) {
            this.getLogger().warning("Can not find the PLAY configuration file in the DSB, please add play.cfg in the container. Running in dowgraded mode...");
        }
        String reg = play.getProperty("play.registry", "http://localhost:8080/registry/RegistryService");
        this.getLogger().info("Initializing topics from the governance engine running at " + reg);
        try {
            List topics = this.getEventGovernance(reg).getTopics();
            if (this.getLogger().isLoggable(Level.INFO)) {
                this.getLogger().info("Available topics : ");
                for (Topic topic : topics) {
                    this.getLogger().info(topic.toString());
                }
            }
            result = TopicSetHelper.getWSNDocument((List)Lists.transform((List)topics, (Function)new Function<Topic, org.petalslink.dsb.jbi.se.wsn.api.Topic>(){

                public org.petalslink.dsb.jbi.se.wsn.api.Topic apply(Topic t) {
                    Component.this.getLogger().fine("Transforming topic " + t);
                    org.petalslink.dsb.jbi.se.wsn.api.Topic result = new org.petalslink.dsb.jbi.se.wsn.api.Topic();
                    result.name = t.getName();
                    result.ns = t.getNs();
                    result.prefix = t.getPrefix();
                    return result;
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void doAddServices() {
        this.getLogger().info("Adding PLAY Web services");
        TopicAwareService service = new TopicAwareService(this.managementService, this.getLogger());
        this.ws.add(this.getService(TopicAware.class, service, "PlayTopic"));
    }

    protected EventGovernance getEventGovernance(String reg) throws RegistryException {
        Registry registry = (Registry)CXFHelper.getClientFromFinalURL((String)reg, Registry.class);
        String govEndpoint = registry.get("org.ow2.play.governance");
        return (EventGovernance)CXFHelper.getClientFromFinalURL((String)govEndpoint, EventGovernance.class);
    }
}

