/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.metadata.client;

import java.util.List;
import javax.jws.WebMethod;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;
import org.petalslink.dsb.cxf.CXFHelper;

public class MetadataClient
implements MetadataService {
    private String url;
    private MetadataService client;

    public MetadataClient(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint can not be null");
        }
        this.url = endpoint;
    }

    protected synchronized MetadataService getClient() {
        if (this.client == null) {
            this.client = (MetadataService)CXFHelper.getClientFromFinalURL((String)this.url, MetadataService.class);
        }
        return this.client;
    }

    @WebMethod
    public void clear() throws MetadataException {
        this.getClient().clear();
    }

    @WebMethod
    public void addMetadata(Resource resource, Metadata metadata) throws MetadataException {
        this.getClient().addMetadata(resource, metadata);
    }

    @WebMethod
    public boolean create(MetaResource metaResource) throws MetadataException {
        return this.getClient().create(metaResource);
    }

    @WebMethod
    public void removeMetadata(Resource resource, Metadata metadata) throws MetadataException {
        this.getClient().removeMetadata(resource, metadata);
    }

    @WebMethod
    public List<Metadata> getMetaData(Resource resource) throws MetadataException {
        return this.getClient().getMetaData(resource);
    }

    @WebMethod
    public Metadata getMetadataValue(Resource resource, String key) throws MetadataException {
        return this.getClient().getMetadataValue(resource, key);
    }

    @WebMethod
    public boolean deleteMetaData(Resource resource) throws MetadataException {
        return this.getClient().deleteMetaData(resource);
    }

    @WebMethod
    public List<MetaResource> getResoucesWithMeta(List<Metadata> include) throws MetadataException {
        return this.getClient().getResoucesWithMeta(include);
    }

    @WebMethod
    public List<MetaResource> list() throws MetadataException {
        return this.getClient().list();
    }

    @WebMethod
    public boolean exists(Resource resource) throws MetadataException {
        return this.getClient().exists(resource);
    }

    public void setMetadata(Resource resource, Metadata metadata) throws MetadataException {
        this.getClient().setMetadata(resource, metadata);
    }
}

