/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.metadata.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.bson.types.BasicBSONList;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.Initializable;
import org.ow2.play.metadata.api.service.MetadataService;
import org.ow2.play.metadata.mongodb.BSONAdapter;

public class MongoMetadataServiceImpl
implements MetadataService,
Initializable {
    private static final String DEFAULT_MONGO_DB_HOSTNAME = "localhost";
    private static final String DEFAULT_MONGO_DB_PORT = "27017";
    private static final String DEFAULT_MONGO_DB_DATABASE_NAME = "play";
    private static final String DEFAULT_MONGO_DB_COLLECTION_NAME = "metadata";
    private String hostname = "localhost";
    private String port = "27017";
    private String databaseName = "play";
    private String collectionName = "metadata";
    private String userName;
    private String password;
    private Mongo mongo;
    private DBCollection collection;
    private Properties properties;
    private boolean initialized = false;
    private static Logger logger = Logger.getLogger(MongoMetadataServiceImpl.class.getName());
    private BSONAdapter bsonAdapter;

    public void init() {
        logger.info("Initializing metadata service");
        if (this.mongo != null) {
            this.close();
        }
        if (this.properties != null) {
            this.hostname = this.properties.getProperty("mongo.hostname", DEFAULT_MONGO_DB_HOSTNAME);
            this.port = this.properties.getProperty("mongo.port", DEFAULT_MONGO_DB_PORT);
            this.userName = this.properties.getProperty("mongo.username", this.userName);
            this.password = this.properties.getProperty("mongo.password", this.password);
            this.collectionName = this.properties.getProperty("mongo.collection", DEFAULT_MONGO_DB_COLLECTION_NAME);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Connection to %s %s with credentials %s %s", this.hostname, this.port, this.userName, "******"));
        }
        List<ServerAddress> addresses = this.getServerAddresses(this.hostname, this.port);
        this.mongo = this.getMongo(addresses);
        DB database = this.getDatabase(this.mongo, this.databaseName);
        if (this.userName != null && this.userName.trim().length() > 0) {
            if (!database.authenticate(this.userName, this.password.toCharArray())) {
                throw new RuntimeException("Unable to authenticate with MongoDB server.");
            }
            this.password = null;
        }
        this.setCollection(database.getCollection(this.collectionName));
        this.initialized = true;
    }

    public void clear() throws MetadataException {
        logger.info("Got a clear call");
        this.checkInitialized();
        this.clearCollection();
    }

    @WebMethod
    public void addMetadata(Resource resource, Metadata metadata) throws MetadataException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Adding metdata %s to resource %s", metadata, resource));
        }
        this.checkInitialized();
        DBObject o = this.findFirst(resource);
        if (o != null) {
            Object meta;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Resource already exists, Add metadata to the current entry");
            }
            if ((meta = o.get(DEFAULT_MONGO_DB_COLLECTION_NAME)) != null && meta instanceof BasicBSONList) {
                DBObject metabson = this.bsonAdapter.createBSON(metadata);
                BasicBSONList list = (BasicBSONList)meta;
                list.add((Object)metabson);
                this.collection.save(o);
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Can not find the list to add metadata to...");
            }
        } else {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Resource does not exists, Create a new meta resource entry in the DB");
            }
            ArrayList<Metadata> list = new ArrayList<Metadata>();
            if (metadata != null) {
                list.add(metadata);
            }
            MetaResource metaResource = new MetaResource(resource, list);
            DBObject bson = this.bsonAdapter.createBSON(metaResource);
            try {
                this.collection.insert(new DBObject[]{bson});
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
        }
    }

    public void setMetadata(Resource resource, Metadata metadata) throws MetadataException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Setting metdata %s to resource %s", metadata, resource));
        }
        this.checkInitialized();
        DBObject o = this.findFirst(resource);
        if (o != null) {
            Object meta;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Resource already exists, Add metadata to the current entry");
            }
            if ((meta = o.get(DEFAULT_MONGO_DB_COLLECTION_NAME)) != null && meta instanceof BasicBSONList) {
                BasicBSONList list = (BasicBSONList)meta;
                boolean found = false;
                for (Object object : list) {
                    DBObject entry;
                    if (object == null || !(object instanceof DBObject) || (entry = (DBObject)object).get("name") == null || !entry.get("name").toString().equals(metadata.getName())) continue;
                    found = true;
                    BasicBSONList bsl = new BasicBSONList();
                    for (Data data : metadata.getData()) {
                        bsl.add((Object)this.bsonAdapter.createBSON(data));
                    }
                    entry.put("data", (Object)bsl);
                }
                if (!found) {
                    DBObject dbo = this.bsonAdapter.createBSON(metadata);
                    list.add((Object)dbo);
                }
                this.collection.save(o);
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Can not find the list to add metadata to...");
            }
        } else {
            throw new MetadataException("Can not add a metadata to a resource that does not exists");
        }
    }

    public boolean create(MetaResource metaResource) throws MetadataException {
        boolean result = true;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Create metaresource " + metaResource);
        }
        if (metaResource == null || metaResource.getResource() == null) {
            logger.warning("Can not create a null resource");
            throw new MetadataException("Can not create a null resource...");
        }
        metaResource.getMetadata().add(new Metadata("http://play.ow2.org/metadata/createdat", new Data("literal", "" + System.currentTimeMillis())));
        this.checkInitialized();
        DBObject o = this.findFirst(metaResource.getResource());
        if (o == null) {
            DBObject bson = this.bsonAdapter.createBSON(metaResource);
            try {
                this.collection.insert(new DBObject[]{bson});
            }
            catch (MongoException e) {
                throw new MetadataException((Throwable)e);
            }
        } else {
            String message = "The resource already exists, can not be created. Use #addMetadata if you want to populate resource";
            logger.warning("The resource already exists, can not be created. Use #addMetadata if you want to populate resource");
            throw new MetadataException("The resource already exists, can not be created. Use #addMetadata if you want to populate resource");
        }
        return result;
    }

    @WebMethod
    public void removeMetadata(Resource resource, Metadata metadata) throws MetadataException {
        throw new MetadataException("Not implemented");
    }

    @WebMethod
    public List<Metadata> getMetaData(Resource resource) throws MetadataException {
        Object o;
        this.checkInitialized();
        ArrayList<Metadata> result = new ArrayList<Metadata>();
        DBObject dbo = this.findFirst(resource);
        if (dbo != null && (o = dbo.get(DEFAULT_MONGO_DB_COLLECTION_NAME)) != null && o instanceof BasicDBList) {
            BasicDBList metalist = (BasicDBList)o;
            for (Object object : metalist) {
                DBObject entry = (DBObject)object;
                Metadata md = new Metadata();
                md.setName(entry.get("name").toString());
                Object data = entry.get("data");
                if (data != null && data instanceof BasicDBList) {
                    BasicDBList list = (BasicDBList)data;
                    for (Object object2 : list) {
                        md.getData().add(new Data(((DBObject)object2).get("type").toString(), ((DBObject)object2).get("value").toString()));
                    }
                }
                result.add(md);
            }
        }
        return result;
    }

    @WebMethod
    public Metadata getMetadataValue(Resource resource, String key) throws MetadataException {
        this.checkInitialized();
        Metadata result = null;
        DBObject dbo = this.findFirst(resource);
        if (dbo != null) {
            MetaResource mr = this.bsonAdapter.readMetaResource(dbo);
            List list = mr.getMetadata();
            Iterator iter = list.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                Metadata metadata = (Metadata)iter.next();
                if (metadata.getName() == null || !metadata.getName().equals(key)) continue;
                found = true;
                result = metadata;
            }
        }
        return result;
    }

    @WebMethod
    public boolean deleteMetaData(Resource resource) throws MetadataException {
        this.checkInitialized();
        boolean deleted = false;
        DBObject o = this.findFirst(resource);
        if (o != null) {
            logger.fine("Deleting the associated resource " + resource);
            deleted = false;
        } else {
            logger.fine("Can not delete the resource, not found in the DB...");
        }
        return deleted;
    }

    @WebMethod
    public List<MetaResource> getResoucesWithMeta(List<Metadata> include) throws MetadataException {
        throw new MetadataException("Not implemented");
    }

    @WebMethod
    public List<MetaResource> list() throws MetadataException {
        this.checkInitialized();
        ArrayList<MetaResource> result = new ArrayList<MetaResource>();
        DBCursor cursor = this.collection.find();
        for (DBObject dbObject : cursor) {
            if (dbObject != null) {
                MetaResource mr;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(dbObject.toString());
                }
                if ((mr = this.bsonAdapter.readMetaResource(dbObject)) == null) continue;
                result.add(mr);
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Null object, not added");
        }
        return result;
    }

    public boolean exists(Resource resource) throws MetadataException {
        if (resource == null || resource.getName() == null || resource.getUrl() == null) {
            throw new MetadataException("Can not search a null object...");
        }
        return this.findFirst(resource) != null;
    }

    protected DB getDatabase(Mongo mongo, String databaseName) {
        return mongo.getDB(databaseName);
    }

    protected DBCollection getDbCollection() {
        return this.collection;
    }

    protected Mongo getMongo(List<ServerAddress> addresses) {
        if (addresses.size() == 1) {
            return new Mongo(addresses.get(0));
        }
        return new Mongo(addresses);
    }

    protected void close() {
        if (this.mongo != null) {
            this.collection = null;
            this.mongo.close();
        }
    }

    public void setCollection(DBCollection collection) {
        assert (collection != null) : "collection must not be null";
        this.collection = collection;
    }

    private List<ServerAddress> getServerAddresses(String hostname, String port) {
        List<Integer> portNums;
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        String[] hosts = hostname.split(" ");
        String[] ports = port.split(" ");
        if (!(ports.length != 1 && ports.length != hosts.length || (portNums = this.getPortNums(ports)).size() != 1 && portNums.size() != hosts.length)) {
            boolean onePort = portNums.size() == 1;
            int i = 0;
            for (String host : hosts) {
                int portNum = onePort ? portNums.get(0) : portNums.get(i);
                try {
                    addresses.add(new ServerAddress(host.trim(), portNum));
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return addresses;
    }

    private List<Integer> getPortNums(String[] ports) {
        ArrayList<Integer> portNums = new ArrayList<Integer>();
        for (String port : ports) {
            try {
                Integer portNum = Integer.valueOf(port.trim());
                if (portNum < 0) continue;
                portNums.add(portNum);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return portNums;
    }

    protected DBObject findFirst(Resource resource) {
        BasicDBObject query = new BasicDBObject();
        BasicDBObject resourceObject = new BasicDBObject();
        resourceObject.put("name", (Object)resource.getName());
        resourceObject.put("url", (Object)resource.getUrl());
        query.put("resource", (Object)resourceObject);
        return this.collection.findOne((DBObject)query);
    }

    protected List<DBObject> findAll(Resource resource) {
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        BasicDBObject query = new BasicDBObject();
        BasicDBObject resourceObject = new BasicDBObject();
        resourceObject.put("name", (Object)resource.getName());
        resourceObject.put("url", (Object)resource.getUrl());
        query.put("resource", (Object)resourceObject);
        DBCursor cursor = this.collection.find((DBObject)query);
        Iterator iter = cursor.iterator();
        while (iter.hasNext()) {
            result.add((DBObject)iter.next());
        }
        return result;
    }

    protected void clearCollection() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove all objects from the collection");
        }
        WriteResult wr = this.getDbCollection().remove((DBObject)new BasicDBObject());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Write result : " + wr);
        }
    }

    protected void checkInitialized() throws MetadataException {
        if (!this.initialized) {
            throw new MetadataException("MongoDB has not been initialized, call #init() first");
        }
    }

    public void setBsonAdapter(BSONAdapter bsonAdapter) {
        this.bsonAdapter = bsonAdapter;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

