/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.metadata.service;

import java.util.List;
import java.util.logging.Logger;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.service.MetadataBootstrap;
import org.ow2.play.metadata.api.service.MetadataLoader;
import org.ow2.play.metadata.api.service.MetadataService;

public class BootstrapServiceImpl
implements MetadataBootstrap {
    private MetadataService metadataService;
    private MetadataLoader metadataLoader;
    static Logger logger = Logger.getLogger(BootstrapServiceImpl.class.getName());

    public void init(List<String> urls) {
        if (this.metadataLoader != null && this.metadataService != null && urls != null) {
            for (String url : urls) {
                logger.info("Loading data from " + url);
                try {
                    List list = this.metadataLoader.load(url);
                    for (MetaResource metaResource : list) {
                        for (Metadata metadata : metaResource.getMetadata()) {
                            this.metadataService.addMetadata(metaResource.getResource(), metadata);
                        }
                    }
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setMetadataLoader(MetadataLoader metadataLoader) {
        this.metadataLoader = metadataLoader;
    }
}

