/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.metadata.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;

public class InMemoryMetadataServiceImpl
implements MetadataService {
    private static Logger logger = Logger.getLogger(InMemoryMetadataServiceImpl.class.getName());
    Map<Resource, Set<Metadata>> metadata = new ConcurrentHashMap<Resource, Set<Metadata>>();

    @WebMethod
    public void addMetadata(Resource resource, Metadata metadata) throws MetadataException {
        logger.info("Add meta to " + resource);
        if (!this.resourceExists(resource)) {
            this.create(resource);
        }
        this.metadata.get(resource).add(metadata);
    }

    @WebMethod
    public boolean create(MetaResource metaResource) throws MetadataException {
        logger.info("Create metaresource " + metaResource);
        if (!this.resourceExists(metaResource.getResource())) {
            this.create(metaResource.getResource());
        }
        for (Metadata md : metaResource.getMetadata()) {
            this.addMetadata(metaResource.getResource(), md);
        }
        return true;
    }

    @WebMethod
    public void clear() throws MetadataException {
        this.metadata = new ConcurrentHashMap<Resource, Set<Metadata>>();
    }

    @WebMethod
    public synchronized void removeMetadata(Resource resource, Metadata metadata) throws MetadataException {
        logger.info("Remove metadata from " + resource);
        if (!this.resourceExists(resource)) {
            return;
        }
        this.metadata.get(resource).remove(metadata);
    }

    @WebMethod
    public List<Metadata> getMetaData(Resource resource) throws MetadataException {
        logger.info("Get metadatas from " + resource);
        if (this.resourceExists(resource)) {
            return new ArrayList<Metadata>((Collection)this.metadata.get(resource));
        }
        return new ArrayList<Metadata>();
    }

    @WebMethod
    public Metadata getMetadataValue(Resource resource, String key) throws MetadataException {
        logger.info("Get metadata value for resource " + resource + " and metakey " + key);
        Metadata result = null;
        if (this.resourceExists(resource)) {
            Set<Metadata> set = this.metadata.get(resource);
            Iterator<Metadata> iter = set.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                Metadata meta = iter.next();
                found = key.equals(meta.getName());
                if (!found) continue;
                result = meta;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod
    public boolean deleteMetaData(Resource resource) throws MetadataException {
        logger.info("Delete metadata from resource " + resource);
        if (this.resourceExists(resource)) {
            Map<Resource, Set<Metadata>> map = this.metadata;
            synchronized (map) {
                this.metadata.remove(resource);
            }
            return true;
        }
        return false;
    }

    @WebMethod
    public List<MetaResource> getResoucesWithMeta(List<Metadata> include) throws MetadataException {
        logger.info("Get resources with meta " + include);
        throw new MetadataException("Not implemented");
    }

    @WebMethod
    public List<MetaResource> list() {
        logger.info("Get list of resources");
        ArrayList<MetaResource> result = new ArrayList<MetaResource>();
        if (this.metadata != null) {
            for (Map.Entry<Resource, Set<Metadata>> metaResource : this.metadata.entrySet()) {
                result.add(new MetaResource(metaResource.getKey(), new ArrayList(metaResource.getValue())));
            }
        }
        return result;
    }

    public void setMetadata(Resource resource, Metadata metadata) throws MetadataException {
    }

    @WebMethod
    public boolean exists(Resource resource) throws MetadataException {
        return this.resourceExists(resource);
    }

    protected boolean resourceExists(Resource r) {
        return r != null && this.metadata.containsKey(r);
    }

    protected synchronized void create(Resource resource) {
        if (!this.resourceExists(resource)) {
            this.metadata.put(resource, new HashSet());
        }
    }
}

