/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.platform.api.service;

import com.google.common.collect.Lists;
import com.sun.istack.logging.Logger;
import java.util.List;
import java.util.logging.Level;
import javax.jws.WebService;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SubscriptionManagement;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.platform.api.APIException;
import org.ow2.play.platform.api.bean.Subscription;
import org.ow2.play.platform.api.bean.SubscriptionResult;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

@WebService
public class SubscriptionService
implements org.ow2.play.platform.api.SubscriptionService {
    private Registry registry;
    private static Logger logger = Logger.getLogger(SubscriptionService.class);

    public SubscriptionResult subscribe(Subscription subscription) throws APIException {
        logger.info("Got a subscribe " + subscription);
        if (subscription == null) {
            throw new APIException("Can not subscribe null");
        }
        if (subscription.subscriber == null) {
            throw new APIException("Can not subscribe for null endpoint");
        }
        if (subscription.topic == null) {
            throw new APIException("Can not subscribe on null topic");
        }
        SubscriptionResult result = new SubscriptionResult();
        result.initialSubscription = subscription;
        SubscriptionManagement client = this.getSubscriptionManagement();
        String subcribeTo = this.getSubscribeToEndpoint();
        org.ow2.play.governance.api.bean.Subscription s = new org.ow2.play.governance.api.bean.Subscription();
        s.setProvider(subcribeTo);
        s.setSubscriber(subscription.subscriber);
        Topic t = new Topic();
        t.setName(subscription.topic.name);
        t.setNs(subscription.topic.ns);
        t.setPrefix(subscription.topic.prefix);
        s.setTopic(t);
        try {
            List list = client.subscribe((List)Lists.newArrayList((Object[])new org.ow2.play.governance.api.bean.Subscription[]{s}));
            if (list == null || list.size() == 0) {
                throw new APIException("Can not get any subscription result");
            }
            org.ow2.play.governance.api.bean.Subscription subcriptionResult = (org.ow2.play.governance.api.bean.Subscription)list.get(0);
            if (subcriptionResult != null) {
                result.subscriptionID = subcriptionResult.getId();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Governance returned " + subcriptionResult);
                }
            } else {
                logger.warning("Can not find subscription result");
            }
        }
        catch (GovernanceExeption e) {
            e.printStackTrace();
            throw new APIException("Can not subscribe");
        }
        return result;
    }

    public boolean unsubscribe(String subscriptionID) throws APIException {
        boolean result = true;
        logger.info("Got an unsubscribe " + subscriptionID);
        SubscriptionManagement client = this.getSubscriptionManagement();
        org.ow2.play.governance.api.bean.Subscription s = new org.ow2.play.governance.api.bean.Subscription();
        s.setId(subscriptionID);
        try {
            List unsub = client.unsubscribe((List)Lists.newArrayList((Object[])new org.ow2.play.governance.api.bean.Subscription[]{s}));
            boolean bl = result = unsub != null && unsub.size() > 0;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Governance returned : " + unsub);
            }
        }
        catch (GovernanceExeption e) {
            e.printStackTrace();
            throw new APIException("Can not unsubscribe for " + subscriptionID);
        }
        return result;
    }

    public SubscriptionManagement getSubscriptionManagement() throws APIException {
        try {
            return (SubscriptionManagement)CXFHelper.getClientFromFinalURL((String)this.registry.get("org.ow2.play.governance.subscription.management"), SubscriptionManagement.class);
        }
        catch (RegistryException e) {
            String msg = "Can not retrieve service information";
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Can not retrieve service information");
            }
            throw new APIException("Can not retrieve service information");
        }
    }

    public String getSubscribeToEndpoint() throws APIException {
        try {
            return this.registry.get("org.ow2.play.dsb.wsn.producer");
        }
        catch (RegistryException e) {
            String msg = "Can not retrieve producer service information";
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Can not retrieve producer service information");
            }
            throw new APIException("Can not retrieve producer service information");
        }
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

