/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.platform.api.service.client;

import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.service.registry.api.Entry;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class ServiceRegistry
implements Registry {
    private Registry client;
    private String url;
    private static Logger logger = Logger.getLogger(ServiceRegistry.class.getName());

    protected synchronized Registry getClient() {
        if (this.client == null) {
            logger.fine("Builidng CXF client");
            this.client = (Registry)CXFHelper.getClientFromFinalURL((String)this.url, Registry.class);
        }
        return this.client;
    }

    @WebMethod
    public void clear() throws RegistryException {
        logger.fine("Clear registry");
        this.getClient().clear();
    }

    @WebMethod
    public String get(String name) throws RegistryException {
        logger.fine("Get endpoint for name " + name);
        return this.getClient().get(name);
    }

    @WebMethod
    public List<String> keys() throws RegistryException {
        logger.info("Get keys");
        return this.getClient().keys();
    }

    @WebMethod
    public void load(String url) throws RegistryException {
        logger.info("Load from " + url);
        this.getClient().load(url);
    }

    @WebMethod
    public void put(String name, String value) throws RegistryException {
        logger.info("Put data in service registry : " + name + " - " + value);
        this.getClient().put(name, value);
    }

    @WebMethod
    public void init() throws RegistryException {
        logger.fine("Initialize service registry");
        this.getClient().init();
    }

    public void setUrl(String url) {
        this.url = url;
        this.client = null;
    }

    @WebMethod
    public List<Entry> entries() throws RegistryException {
        return this.getClient().entries();
    }
}

