/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.platform.client.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.play.platform.api.API;
import org.ow2.play.platform.api.APIException;
import org.ow2.play.platform.api.SubscriptionService;
import org.ow2.play.platform.api.bean.Property;
import org.ow2.play.platform.api.bean.Subscription;
import org.ow2.play.platform.api.bean.SubscriptionResult;
import org.ow2.play.platform.client.api.ClientException;
import org.petalslink.dsb.cxf.CXFHelper;

public class PlatformClient
implements org.ow2.play.platform.client.api.PlatformClient {
    private SubscriptionService subscriptionManager;
    private Map<String, String> endpoints = new HashMap<String, String>();
    private String apiEndpoint;
    protected List<SubscriptionResult> localSubscriptions = new ArrayList<SubscriptionResult>();

    public void connect(String apiEndpoint, String authtoken) throws ClientException {
        if (apiEndpoint == null) {
            throw new ClientException("Null endpoint is not allowed");
        }
        this.apiEndpoint = apiEndpoint;
        try {
            List props = ((API)CXFHelper.getClientFromFinalURL((String)this.getEndpoint("APIService"), API.class)).connect(authtoken);
            if (props != null) {
                for (Property property : props) {
                    this.endpoints.put(property.name, property.value);
                }
            }
        }
        catch (APIException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public synchronized SubscriptionService getSubscriptionManager() throws ClientException {
        this.checkConnected();
        if (this.subscriptionManager == null) {
            this.subscriptionManager = new SubscriptionServiceImpl();
        }
        return this.subscriptionManager;
    }

    private void checkConnected() throws ClientException {
        if (this.apiEndpoint == null) {
            throw new ClientException("Please connect first");
        }
    }

    protected String getEndpoint(String serviceId) {
        return this.apiEndpoint.endsWith("/") ? this.apiEndpoint + serviceId : this.apiEndpoint + "/" + serviceId;
    }

    class SubscriptionServiceImpl
    implements SubscriptionService {
        private SubscriptionService wsClient;

        public SubscriptionResult subscribe(Subscription subscription) throws ClientException {
            SubscriptionResult result = null;
            try {
                result = this.getSubscriptionService().subscribe(subscription);
                if (result != null) {
                    PlatformClient.this.localSubscriptions.add(result);
                }
            }
            catch (APIException e) {
                throw new ClientException((Throwable)e);
            }
            return result;
        }

        public boolean unsubscribe(String subscriptionID) throws ClientException {
            boolean result = true;
            try {
                result = this.getSubscriptionService().unsubscribe(subscriptionID);
            }
            catch (APIException e) {
                throw new ClientException((Throwable)e);
            }
            if (result) {
                // empty if block
            }
            return result;
        }

        private synchronized SubscriptionService getSubscriptionService() {
            if (this.wsClient == null) {
                this.wsClient = (SubscriptionService)CXFHelper.getClientFromFinalURL((String)PlatformClient.this.getEndpoint("SubscriptionService"), SubscriptionService.class);
            }
            return this.wsClient;
        }
    }
}

