/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.service.client;

import java.util.HashMap;
import java.util.Map;
import org.ow2.play.governance.api.EventGovernance;
import org.ow2.play.governance.api.SimplePatternService;
import org.ow2.play.governance.api.SubscriptionService;
import org.ow2.play.governance.api.TopicAware;
import org.ow2.play.governance.api.TopicRegistry;
import org.ow2.play.metadata.api.service.MetadataService;
import org.ow2.play.service.client.ClientException;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;
import org.petalslink.dsb.cxf.CXFHelper;

public class PlayClient {
    protected String registryEndpoint;
    private Registry client;

    public PlayClient(String registryEndpoint) {
        this.registryEndpoint = registryEndpoint;
    }

    protected synchronized Registry getRegistryClient() {
        if (this.client == null) {
            this.client = (Registry)CXFHelper.getClientFromFinalURL((String)this.registryEndpoint, Registry.class);
        }
        return this.client;
    }

    protected <T> T getWSClient(String key, Class<T> clazz) throws ClientException {
        try {
            return (T)CXFHelper.getClientFromFinalURL((String)this.getRegistryClient().get(key), clazz);
        }
        catch (RegistryException e) {
            throw new ClientException(e);
        }
    }

    public Map<String, String> list() throws ClientException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (String key : this.getRegistryClient().keys()) {
                result.put(key, this.getRegistryClient().get(key));
            }
        }
        catch (RegistryException e) {
            throw new ClientException(e);
        }
        return result;
    }

    public TopicAware getDSBTopicAware() throws ClientException {
        return this.getWSClient("org.ow2.play.dsb.topic.business.management", TopicAware.class);
    }

    public MetadataService getMetadataService() throws ClientException {
        return this.getWSClient("org.ow2.play.metadata", MetadataService.class);
    }

    public EventGovernance getEventGovernance() throws ClientException {
        return this.getWSClient("org.ow2.play.governance", EventGovernance.class);
    }

    public SubscriptionService getSubscriptionService() throws ClientException {
        return this.getWSClient("org.ow2.play.governance.subscription.service", SubscriptionService.class);
    }

    public TopicRegistry getTopicRegistryService() throws ClientException {
        return this.getWSClient("org.ow2.play.governance.topic.registry", TopicRegistry.class);
    }

    public SimplePatternService getPatternService() throws ClientException {
        return this.getWSClient("org.ow2.play.governance.pattern.service", SimplePatternService.class);
    }
}

