/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.service.registry;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.service.registry.api.Entry;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;

public class InMemoryRegistryImpl
implements Registry {
    private static Logger logger = Logger.getLogger(InMemoryRegistryImpl.class.getName());
    private Map<String, String> map;

    public InMemoryRegistryImpl() {
        try {
            this.init();
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public void init() throws RegistryException {
        this.map = new ConcurrentHashMap<String, String>();
    }

    @WebMethod
    public String get(String key) {
        logger.info("Get value for key : " + key);
        return this.map.get(key);
    }

    @WebMethod
    public void put(String key, String value) {
        logger.info("Put value '" + value + "' for key '" + key + "'");
        if (key != null && value != null && this.isURL(value)) {
            this.map.put(key, value);
        }
    }

    @WebMethod
    public List<String> keys() {
        return new ArrayList<String>(this.map.keySet());
    }

    @WebMethod
    public void clear() {
        this.map.clear();
    }

    @WebMethod
    public void load(String url) {
        if (url != null) {
            try {
                URL u = new URL(url);
                Properties props = new Properties();
                props.load(u.openStream());
                for (Object key : props.keySet()) {
                    String value = props.getProperty(key.toString());
                    if (!this.isURL(value)) continue;
                    this.put(key.toString(), value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    @WebMethod
    public List<Entry> entries() throws RegistryException {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (String key : this.keys()) {
            Entry e = new Entry();
            e.key = key;
            e.value = this.get(key);
            result.add(e);
        }
        return result;
    }

    protected boolean isURL(String url) {
        if (url == null) {
            return false;
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

