/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMocked;
import com.ebmwebsourcing.eventcloud.mocked.util.NotificationConsumerMock;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import java.io.ByteArrayInputStream;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class EventMockedTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startServer() throws CloudManagementException {
        EventCloudMocked adminCloud = null;
        try {
            adminCloud = new EventCloudMocked("http://localhost:9666/EventCloud");
            adminCloud.start();
        }
        finally {
            if (adminCloud != null) {
                adminCloud.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subscribeOnEventCloudTest() throws Exception {
        EventCloudMocked eventcloud = null;
        try {
            eventcloud = new EventCloudMocked("http://localhost:9666/EventCloud");
            eventcloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:9666/EventCloud");
            Subscribe payload = WSNHelper.createSubscription((String)"http://subscriptionClient.com/", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (QName[])new QName[0]);
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            System.out.println("subscribe:\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            EJaxbSubscribeResponse response = seaCloudClient.subscribe(doc);
            Assert.assertNotNull((Object)response);
        }
        finally {
            if (eventcloud != null) {
                eventcloud.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subscribeAndNotifyOnEventCloudTest() throws Exception {
        EventCloudMocked eventcloud = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            eventcloud = new EventCloudMocked("http://localhost:9666/EventCloud");
            eventcloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:9666/EventCloud");
            Subscribe payload = WSNHelper.createSubscription((String)"http://localhost:9601/BusConsumerService", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (QName[])new QName[0]);
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            EJaxbSubscribeResponse response = seaCloudClient.subscribe(doc);
            Assert.assertNotNull((Object)response);
            String busNotifConsumerAddress = "http://localhost:9601/BusConsumerService";
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, busNotifConsumerAddress);
            Document content = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text>Hello World</text>".getBytes()));
            Notify notify = WSNHelper.createNotification((String)"http://subscriptionClient.com/", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (Object)content);
            doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
            seaCloudClient.notify(doc);
            while (notifier.getNotifications().size() == 0) {
                Thread.sleep(200L);
            }
            Assert.assertEquals((int)1, (int)notifier.getNotifications().size());
        }
        finally {
            if (eventcloud != null) {
                eventcloud.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subscribeAndNotifyWithMessagesOnEventCloudTest() throws Exception {
        EventCloudMocked eventcloud = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            eventcloud = new EventCloudMocked("http://localhost:9666/EventCloud");
            eventcloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:9666/EventCloud");
            Subscribe payload = WSNHelper.createSubscription((String)"http://localhost:9601/BusConsumerService", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (QName[])new QName[]{new QName("http://test", "text")});
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            EJaxbSubscribeResponse response = seaCloudClient.subscribe(doc);
            Assert.assertNotNull((Object)response);
            String busNotifConsumerAddress = "http://localhost:9601/BusConsumerService";
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, busNotifConsumerAddress);
            Document content = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text xmlns=\"http://test\" >Hello World</text>".getBytes()));
            Notify notify = WSNHelper.createNotification((String)"http://subscriptionClient.com/", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (Object)content);
            doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
            seaCloudClient.notify(doc);
            while (notifier.getNotifications().size() == 0) {
                Thread.sleep(200L);
            }
            Assert.assertEquals((int)1, (int)notifier.getNotifications().size());
        }
        finally {
            if (eventcloud != null) {
                eventcloud.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }
}

