/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.SubstanceEtchedBorder;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstancePaneBorder;
import org.jvnet.substance.SubstanceToolBarBorder;
import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.DarkGrayColorScheme;
import org.jvnet.substance.color.DarkMetallicColorScheme;
import org.jvnet.substance.color.InvertedColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.NegatedColorScheme;
import org.jvnet.substance.color.SunGlareColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.scroll.SubstanceScrollPaneBorder;
import org.jvnet.substance.theme.MixedThemeInfo;
import org.jvnet.substance.theme.SubstanceDeuteranopiaTheme;
import org.jvnet.substance.theme.SubstanceHueShiftTheme;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceNegatedTheme;
import org.jvnet.substance.theme.SubstanceProtanopiaTheme;
import org.jvnet.substance.theme.SubstanceSaturatedTheme;
import org.jvnet.substance.theme.SubstanceShadeTheme;
import org.jvnet.substance.theme.SubstanceTintTheme;
import org.jvnet.substance.theme.SubstanceToneTheme;
import org.jvnet.substance.theme.SubstanceTritanopiaTheme;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.title.SubstanceHeaderPainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTrait;
import org.jvnet.substance.utils.icon.CheckBoxMenuItemIcon;
import org.jvnet.substance.utils.icon.RadioButtonMenuItemIcon;

public class SubstanceTheme
implements SubstanceTrait {
    private ColorScheme colorScheme;
    private ThemeKind kind;
    private String displayName;
    public static ColorScheme AQUA = new AquaColorScheme();
    public static ColorScheme GREEN = new BottleGreenColorScheme();
    public static ColorScheme YELLOW = new SunGlareColorScheme();
    public static ColorScheme ORANGE = new SunfireRedColorScheme();
    private static ColorScheme METALLIC_SCHEME = new MetallicColorScheme();
    private static ColorScheme INVERTED_METALLIC_SCHEME = new InvertedColorScheme(METALLIC_SCHEME);
    private static ColorScheme NEGATED_METALLIC_SCHEME = new NegatedColorScheme(METALLIC_SCHEME);
    private static ColorScheme DARK_METALLIC_SCHEME = new DarkMetallicColorScheme();
    private static ColorScheme DARK_GRAY_SCHEME = new DarkGrayColorScheme();
    private static ColorScheme LIGHT_GRAY_SCHEME = new LightGrayColorScheme();
    private static ColorScheme INVERTED_LIGHT_GRAY_SCHEME = new InvertedColorScheme(LIGHT_GRAY_SCHEME);
    private static ColorScheme NEGATED_LIGHT_GRAY_SCHEME = new NegatedColorScheme(LIGHT_GRAY_SCHEME);
    private static SubstanceTheme METALLIC = new SubstanceTheme(METALLIC_SCHEME, "Metallic", ThemeKind.COLD);
    private static SubstanceTheme INVERTED_METALLIC = new SubstanceTheme(INVERTED_METALLIC_SCHEME, "Inverted Metallic", ThemeKind.INVERTED);
    private static SubstanceTheme NEGATED_METALLIC = new SubstanceTheme(NEGATED_METALLIC_SCHEME, "Negated Metallic", ThemeKind.NEGATED);
    private static SubstanceTheme DARK_METALLIC = new SubstanceTheme(DARK_METALLIC_SCHEME, "Dark Metallic", ThemeKind.DARK);
    private static SubstanceTheme LIGHT_GRAY = new SubstanceTheme(LIGHT_GRAY_SCHEME, "Light Gray", ThemeKind.COLD);
    private static SubstanceTheme DARK_GRAY = LIGHT_GRAY.negate();
    private static SubstanceTheme INVERTED_LIGHT_GRAY = new SubstanceTheme(INVERTED_LIGHT_GRAY_SCHEME, "Inverted Light Gray", ThemeKind.INVERTED);
    private static SubstanceTheme NEGATED_LIGHT_GRAY = new SubstanceTheme(NEGATED_LIGHT_GRAY_SCHEME, "Negated Light Gray", ThemeKind.NEGATED);
    private SubstanceTheme pressedTheme;

    public SubstanceTheme(ColorScheme colorScheme, String displayName, ThemeKind themeKind) {
        this.kind = themeKind;
        this.colorScheme = colorScheme;
        this.displayName = displayName;
        if (colorScheme instanceof AquaColorScheme) {
            AQUA = colorScheme;
        }
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public String getThemeName() {
        return this.getDisplayName();
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        UIDefaults.LazyValue menuArrowIcon = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new Icon(){
                    Icon ltrIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getArrowIconHeight(SubstanceSizeUtils.getControlFontSize()) - 1, SubstanceSizeUtils.getArrowStrokeWidth(SubstanceSizeUtils.getControlFontSize()), 3, SubstanceCoreUtilities.getActiveTheme(null, true));
                    Icon rtlIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getArrowIconHeight(SubstanceSizeUtils.getControlFontSize()) - 1, SubstanceSizeUtils.getArrowStrokeWidth(SubstanceSizeUtils.getControlFontSize()), 7, SubstanceCoreUtilities.getActiveTheme(null, true));
                    Icon ltrIconDisabled = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getArrowIconHeight(SubstanceSizeUtils.getControlFontSize()) - 1, SubstanceSizeUtils.getArrowStrokeWidth(SubstanceSizeUtils.getControlFontSize()), 3, SubstanceCoreUtilities.getDisabledTheme(null, true));
                    Icon rtlIconDisabled = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getArrowIconHeight(SubstanceSizeUtils.getControlFontSize()) - 1, SubstanceSizeUtils.getArrowStrokeWidth(SubstanceSizeUtils.getControlFontSize()), 7, SubstanceCoreUtilities.getDisabledTheme(null, true));

                    public int getIconHeight() {
                        return 7;
                    }

                    public int getIconWidth() {
                        return 5;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (c.getComponentOrientation().isLeftToRight()) {
                            if (c.isEnabled()) {
                                this.ltrIcon.paintIcon(c, g, x, y);
                            } else {
                                this.ltrIconDisabled.paintIcon(c, g, x, y);
                            }
                        } else if (c.isEnabled()) {
                            this.rtlIcon.paintIcon(c, g, x, y);
                        } else {
                            this.rtlIconDisabled.paintIcon(c, g, x, y);
                        }
                    }
                };
            }
        };
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new SubstanceDefaultListCellRenderer.SubstanceUIResource();
            }
        };
        ColorUIResource controlText = new ColorUIResource(this.colorScheme.getLightColor());
        final ColorUIResource foregroundColor = this.getForegroundColor();
        ColorUIResource backgroundColor = new ColorUIResource(this.getBackgroundColor());
        ColorUIResource backgroundLightColor = new ColorUIResource(this.getLightBackgroundColor());
        ColorUIResource disabledForegroundColor = new ColorUIResource(this.getDisabledForegroundColor());
        ColorUIResource disabledBackgroundColor = new ColorUIResource(this.getDisabledBackgroundColor());
        ColorUIResource lineColor = new ColorUIResource(this.getLineColor());
        ColorUIResource lineColorDefault = new ColorUIResource(this.getLineColorDefault());
        int lcb = SubstanceColorUtilities.getColorBrightness(lineColor.getRGB());
        ColorUIResource lineBwColor = new ColorUIResource(new Color(lcb, lcb, lcb));
        ColorUIResource selectionBackgroundColor = new ColorUIResource(this.getSelectionBackgroundColor());
        ColorUIResource selectionForegroundColor = new ColorUIResource(this.getSelectionForegroundColor());
        ColorUIResource selectionCellForegroundColor = new ColorUIResource(this.getSelectionCellForegroundColor());
        BorderUIResource.CompoundBorderUIResource regularMarginBorder = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(), new BasicBorders.MarginBorder());
        SubstanceBorder regularBorder = new SubstanceBorder();
        BorderUIResource.CompoundBorderUIResource textBorder = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
        SubstanceBorder comboBorder = new SubstanceBorder(SubstanceSizeUtils.getComboBorderInsets(SubstanceSizeUtils.getControlFontSize()));
        BorderUIResource.CompoundBorderUIResource spinnerBorder = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
        ColorScheme activeScheme = this.getActiveTheme().getColorScheme();
        ColorScheme defaultScheme = this.getDefaultColorScheme();
        final SubstanceTheme topDecorationTheme = this.getActiveTitlePaneTheme();
        SubstanceTitlePainter titlePainter = SubstanceLookAndFeel.getCurrentTitlePainter();
        boolean shouldUseHeaderPainter = titlePainter instanceof SubstanceHeaderPainter;
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        IconUIResource emptyIcon = new IconUIResource(new Icon(){

            public int getIconHeight() {
                return 2;
            }

            public int getIconWidth() {
                return 2;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        });
        Object[] defaults = new Object[]{"control", controlText, "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", passwordInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.disabledText", disabledForegroundColor, "Button.foreground", foregroundColor, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "CheckBox.background", backgroundColor, "CheckBox.border", new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getControlFontSize()), new BasicBorders.MarginBorder()), "CheckBox.disabledText", disabledForegroundColor, "CheckBox.foreground", foregroundColor, "CheckBoxMenuItem.acceleratorForeground", foregroundColor, "CheckBoxMenuItem.acceleratorSelectionForeground", foregroundColor, "CheckBoxMenuItem.background", backgroundColor, "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", new CheckBoxMenuItemIcon(null, 1 + SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize())), "CheckBoxMenuItem.disabledForeground", disabledForegroundColor, "CheckBoxMenuItem.foreground", foregroundColor, "CheckBoxMenuItem.selectionForeground", selectionCellForegroundColor, "ColorChooser.background", backgroundColor, "ColorChooser.foreground", foregroundColor, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.background", backgroundLightColor, "ComboBox.border", comboBorder, "ComboBox.disabledBackground", backgroundLightColor, "ComboBox.disabledForeground", disabledForegroundColor, "ComboBox.foreground", foregroundColor, "ComboBox.selectionBackground", backgroundLightColor, "ComboBox.selectionForeground", foregroundColor, "DesktopIcon.border", regularMarginBorder, "DesktopIcon.width", new Integer(140), "Desktop.background", new ColorUIResource(new Color(0, true)), "Desktop.foreground", foregroundColor, "Dialog.background", backgroundColor, "EditorPane.background", backgroundLightColor, "EditorPane.border", textBorder, "EditorPane.foreground", foregroundColor, "EditorPane.caretForeground", foregroundColor, "EditorPane.disabledBackground", disabledBackgroundColor, "EditorPane.inactiveBackground", disabledBackgroundColor, "EditorPane.inactiveForeground", disabledForegroundColor, "EditorPane.selectionBackground", selectionBackgroundColor, "EditorPane.selectionForeground", selectionForegroundColor, "FileChooser.upFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/go-up.png");
            }
        }, "FileChooser.newFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder-new.png");
            }
        }, "FileChooser.homeFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/user-home.png");
            }
        }, "FileChooser.listViewIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_list.png");
            }
        }, "FileChooser.detailsViewIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_detail.png");
            }
        }, "FileChooser.viewMenuLabelText", "View", "FileChooser.refreshActionLabelText", "Refresh", "FileChooser.newFolderActionLabelText", "New Folder", "FileChooser.listViewActionLabelText", "List", "FileChooser.detailsViewActionLabelText", "Details", "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "FileChooser.usesSingleFilePane", Boolean.TRUE, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"}), "FileView.computerIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/computer.png");
            }
        }, "FileView.directoryIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder.png");
            }
        }, "FileView.fileIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/text-x-generic.png");
            }
        }, "FileView.floppyDriveIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/media-floppy.png");
            }
        }, "FileView.hardDriveIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/drive-harddisk.png");
            }
        }, "FormattedTextField.background", backgroundLightColor, "FormattedTextField.border", textBorder, "FormattedTextField.caretForeground", foregroundColor, "FormattedTextField.disabledBackground", disabledBackgroundColor, "FormattedTextField.foreground", foregroundColor, "FormattedTextField.inactiveBackground", disabledBackgroundColor, "FormattedTextField.inactiveForeground", disabledForegroundColor, "FormattedTextField.selectionBackground", selectionBackgroundColor, "FormattedTextField.selectionForeground", selectionForegroundColor, "InternalFrame.activeTitleBackground", selectionForegroundColor, "InternalFrame.inactiveTitleBackground", foregroundColor, "InternalFrame.border", new BorderUIResource(new SubstancePaneBorder()), "InternalFrame.closeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(topDecorationTheme);
            }
        }, "InternalFrame.iconifyIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMinimizeIcon(topDecorationTheme);
            }
        }, "InternalFrame.maximizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMaximizeIcon(topDecorationTheme);
            }
        }, "InternalFrame.minimizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getRestoreIcon(topDecorationTheme);
            }
        }, "InternalFrame.paletteCloseIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(topDecorationTheme);
            }
        }, "Label.background", backgroundColor, "Label.foreground", foregroundColor, "Label.disabledText", disabledForegroundColor, "Label.disabledForeground", disabledForegroundColor, "List.background", backgroundColor, "List.cellRenderer", listCellRendererActiveValue, "List.focusCellHighlightBorder", regularBorder, "List.foreground", foregroundColor, "List.selectionBackground", new ColorUIResource(activeScheme.getLightColor()), "List.selectionForeground", selectionCellForegroundColor, "Menu.arrowIcon", menuArrowIcon, "Menu.background", backgroundColor, "Menu.borderPainted", Boolean.FALSE, "Menu.checkIcon", null, "Menu.disabledForeground", disabledForegroundColor, "Menu.foreground", foregroundColor, "Menu.selectionForeground", selectionCellForegroundColor, "MenuBar.background", shouldUseHeaderPainter ? new ColorUIResource(this.getActiveTitlePaneTheme().getColorScheme().getMidColor()) : backgroundColor, "MenuBar.foreground", shouldUseHeaderPainter ? new ColorUIResource(this.getActiveTitlePaneTheme().getForegroundColor()) : foregroundColor, "MenuBar.border", null, "MenuItem.acceleratorForeground", foregroundColor, "MenuItem.acceleratorSelectionForeground", foregroundColor, "MenuItem.background", backgroundColor, "MenuItem.borderPainted", Boolean.FALSE, "MenuItem.checkIcon", null, "MenuItem.disabledForeground", disabledForegroundColor, "MenuItem.foreground", foregroundColor, "MenuItem.selectionForeground", selectionCellForegroundColor, "OptionPane.background", backgroundColor, "OptionPane.errorIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
        }, "OptionPane.foreground", foregroundColor, "OptionPane.informationIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
        }, "OptionPane.messageForeground", foregroundColor, "OptionPane.questionIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        }, "OptionPane.warningIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
        }, "Panel.background", backgroundColor, "Panel.foreground", foregroundColor, "PasswordField.background", backgroundLightColor, "PasswordField.border", textBorder, "PasswordField.caretForeground", foregroundColor, "PasswordField.disabledBackground", disabledBackgroundColor, "PasswordField.foreground", foregroundColor, "PasswordField.inactiveBackground", disabledBackgroundColor, "PasswordField.inactiveForeground", disabledForegroundColor, "PasswordField.selectionBackground", selectionBackgroundColor, "PasswordField.selectionForeground", selectionForegroundColor, "PopupMenu.background", backgroundColor, "PopupMenu.border", regularMarginBorder, "ProgressBar.border", new BorderUIResource(new SubstanceBorder()), "ProgressBar.cycleTime", new Integer(1000), "ProgressBar.repaintInterval", new Integer(50), "ProgressBar.horizontalSize", new DimensionUIResource(146, SubstanceSizeUtils.getControlFontSize()), "ProgressBar.verticalSize", new DimensionUIResource(SubstanceSizeUtils.getControlFontSize(), 146), "ProgressBar.selectionBackground", foregroundColor, "ProgressBar.selectionForeground", foregroundColor, "RadioButton.background", backgroundColor, "RadioButton.border", new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getControlFontSize()), new BasicBorders.MarginBorder()), "RadioButton.foreground", foregroundColor, "RadioButton.disabledText", disabledForegroundColor, "RadioButtonMenuItem.acceleratorForeground", foregroundColor, "RadioButtonMenuItem.acceleratorSelectionForeground", foregroundColor, "RadioButtonMenuItem.background", backgroundColor, "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", new RadioButtonMenuItemIcon(null, SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize())), "RadioButtonMenuItem.disabledForeground", disabledForegroundColor, "RadioButtonMenuItem.foreground", foregroundColor, "RadioButtonMenuItem.selectionForeground", selectionCellForegroundColor, "RootPane.background", backgroundColor, "RootPane.border", new SubstancePaneBorder(), "ScrollBar.background", backgroundColor, "ScrollBar.width", new Integer(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize())), "ScrollBar.minimumThumbSize", new DimensionUIResource(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2), "ScrollPane.background", backgroundColor, "ScrollPane.foreground", foregroundColor, "ScrollPane.border", new SubstanceScrollPaneBorder(), "Separator.background", backgroundColor, "Separator.foreground", lineBwColor, "Slider.altTrackColor", lineColor, "Slider.background", backgroundColor, "Slider.darkShadow", lineColor, "Slider.focus", lineColor, "Slider.focusInsets", new InsetsUIResource(2, 2, 0, 2), "Slider.foreground", lineColor, "Slider.highlight", backgroundLightColor, "Slider.shadow", lineColor, "Slider.tickColor", foregroundColor, "Spinner.arrowButtonInsets", null, "Spinner.background", backgroundLightColor, "Spinner.border", spinnerBorder, "Spinner.foreground", foregroundColor, "Spinner.editorBorderPainted", Boolean.TRUE, "SplitPane.background", backgroundColor, "SplitPane.foreground", foregroundColor, "SplitPane.dividerFocusColor", backgroundColor, "SplitPaneDivider.draggingColor", backgroundColor, "SplitPane.border", new BorderUIResource(new EmptyBorder(0, 0, 0, 0)), "SplitPane.dividerSize", new Integer(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) + SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getControlFontSize(), -1, 6, -1, true)), "SplitPaneDivider.border", new BorderUIResource(new EmptyBorder(1, 1, 1, 1)), "TabbedPane.tabAreaBackground", backgroundColor, "TabbedPane.unselectedBackground", backgroundColor, "TabbedPane.background", backgroundColor, "TabbedPane.borderHightlightColor", new ColorUIResource(activeScheme.getMidColor()), "TabbedPane.contentAreaColor", new ColorUIResource(this.colorScheme.getUltraLightColor()), "TabbedPane.contentBorderInsets", new InsetsUIResource(4, 4, 4, 4), "TabbedPane.contentOpaque", Boolean.FALSE, "TabbedPane.darkShadow", SubstanceCoreUtilities.isThemeDark(this) ? new ColorUIResource(activeScheme.getDarkColor()) : new ColorUIResource(activeScheme.getMidColor()), "TabbedPane.focus", foregroundColor, "TabbedPane.foreground", foregroundColor, "TabbedPane.highlight", new ColorUIResource(activeScheme.getLightColor()), "TabbedPane.light", SubstanceCoreUtilities.isThemeDark(this) ? new ColorUIResource(SubstanceColorUtilities.getAlphaColor(defaultScheme.getUltraDarkColor(), 100)) : new ColorUIResource(defaultScheme.getLightColor()), "TabbedPane.selected", new ColorUIResource(activeScheme.getExtraLightColor()), "TabbedPane.selectedForeground", foregroundColor, "TabbedPane.selectHighlight", new ColorUIResource(activeScheme.getMidColor()), "TabbedPane.shadow", new ColorUIResource(SubstanceColorUtilities.getInterpolatedColor(defaultScheme.getExtraLightColor(), defaultScheme.getLightColor(), 0.5)), "TabbedPane.tabRunOverlay", new Integer(0), "Table.background", backgroundColor, "Table.focusCellBackground", selectionBackgroundColor, "Table.focusCellForeground", foregroundColor, "Table.focusCellHighlightBorder", new SubstanceBorder(), "Table.foreground", foregroundColor, "Table.gridColor", lineColorDefault, "Table.scrollPaneBorder", regularMarginBorder, "Table.selectionBackground", selectionBackgroundColor, "Table.selectionForeground", selectionCellForegroundColor, "TableHeader.cellBorder", null, "TableHeader.foreground", foregroundColor, "TableHeader.background", backgroundColor, "TextArea.background", backgroundLightColor, "TextArea.border", textBorder, "TextArea.caretForeground", foregroundColor, "TextArea.disabledBackground", disabledBackgroundColor, "TextArea.foreground", foregroundColor, "TextArea.inactiveBackground", disabledBackgroundColor, "TextArea.inactiveForeground", disabledForegroundColor, "TextArea.selectionBackground", selectionBackgroundColor, "TextArea.selectionForeground", selectionForegroundColor, "TextField.background", backgroundLightColor, "TextField.border", textBorder, "TextField.caretForeground", foregroundColor, "TextField.disabledBackground", disabledBackgroundColor, "TextField.foreground", foregroundColor, "TextField.inactiveBackground", disabledBackgroundColor, "TextField.inactiveForeground", disabledForegroundColor, "TextField.selectionBackground", selectionBackgroundColor, "TextField.selectionForeground", selectionForegroundColor, "TextPane.background", backgroundLightColor, "TextPane.border", textBorder, "TextPane.disabledBackground", disabledBackgroundColor, "TextPane.foreground", foregroundColor, "TextPane.caretForeground", foregroundColor, "TextPane.inactiveBackground", disabledBackgroundColor, "TextPane.inactiveForeground", disabledForegroundColor, "TextPane.selectionBackground", selectionBackgroundColor, "TextPane.selectionForeground", selectionForegroundColor, "TitledBorder.titleColor", foregroundColor, "TitledBorder.border", new SubstanceEtchedBorder(), "ToggleButton.foreground", foregroundColor, "ToggleButton.disabledText", disabledForegroundColor, "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToolBar.background", backgroundColor, "ToolBar.border", new BorderUIResource(new SubstanceToolBarBorder()), "ToolBar.isRollover", Boolean.TRUE, "ToolBar.foreground", foregroundColor, "ToolBarSeparator.background", backgroundColor, "ToolBarSeparator.foreground", lineBwColor, "ToolBar.separatorSize", null, "ToolTip.border", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new LineBorder(foregroundColor);
            }
        }, "ToolTip.borderInactive", regularMarginBorder, "ToolTip.background", backgroundColor, "ToolTip.backgroundInactive", new ColorUIResource(SubstanceTheme.getDefaultColorScheme(this.kind).getExtraLightColor()), "ToolTip.foreground", foregroundColor, "ToolTip.foregroundInactive", disabledForegroundColor, "Tree.closedIcon", emptyIcon, "Tree.collapsedIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(SubstanceSizeUtils.getControlFontSize(), null, SubstanceTheme.this.getDefaultTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), true)));
            }
        }, "Tree.expandedIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(SubstanceSizeUtils.getControlFontSize(), null, SubstanceTheme.this.getDefaultTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), false)));
            }
        }, "Tree.leafIcon", emptyIcon, "Tree.openIcon", emptyIcon, "Tree.background", backgroundColor, "Tree.selectionBackground", backgroundLightColor, "Tree.foreground", foregroundColor, "Tree.hash", lineColorDefault, "Tree.rowHeight", new Integer(0), "Tree.selectionBorderColor", lineColor, "Tree.selectionForeground", selectionCellForegroundColor, "Tree.textBackground", backgroundColor, "Tree.textForeground", foregroundColor, "Viewport.background", backgroundColor, "Viewport.foreground", foregroundColor};
        table.putDefaults(defaults);
    }

    public ColorUIResource getForegroundColor() {
        return new ColorUIResource(SubstanceColorUtilities.getForegroundColor(this));
    }

    public Color getSelectionCellForegroundColor() {
        return SubstanceColorUtilities.getForegroundColor(this.getHighlightTheme(null, ComponentState.SELECTED));
    }

    public Color getSelectionForegroundColor() {
        return SubstanceColorUtilities.getSelectionForegroundColor(this);
    }

    public Color getSelectionBackgroundColor() {
        return SubstanceColorUtilities.getSelectionBackgroundColor(this);
    }

    public Color getLineColor() {
        return SubstanceColorUtilities.getLineColor(this);
    }

    public Color getLineColorDefault() {
        return SubstanceColorUtilities.getLineColor(this.getDefaultTheme());
    }

    public Color getDisabledBackgroundColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.getBackgroundColor(), this.getLightBackgroundColor(), 0.5);
    }

    public Color getDisabledForegroundColor() {
        return SubstanceColorUtilities.getDisabledForegroundColor(this);
    }

    public Color getLightBackgroundColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.getDefaultColorScheme().getUltraLightColor(), this.getDefaultColorScheme().getExtraLightColor(), 0.8);
    }

    public Color getBackgroundColor() {
        return SubstanceColorUtilities.getBackgroundColor(this);
    }

    public ThemeKind getKind() {
        return this.kind;
    }

    public static ColorScheme getDefaultColorScheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_METALLIC_SCHEME;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_LIGHT_GRAY_SCHEME;
        }
        if (themeKind == ThemeKind.NEGATED) {
            return NEGATED_LIGHT_GRAY_SCHEME;
        }
        return METALLIC_SCHEME;
    }

    private static SubstanceTheme getDefaultTheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_METALLIC;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_LIGHT_GRAY;
        }
        if (themeKind == ThemeKind.NEGATED) {
            return NEGATED_LIGHT_GRAY;
        }
        return METALLIC;
    }

    public static ColorScheme getDisabledColorScheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_GRAY_SCHEME;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_METALLIC_SCHEME;
        }
        if (themeKind == ThemeKind.NEGATED) {
            return NEGATED_METALLIC_SCHEME;
        }
        return LIGHT_GRAY_SCHEME;
    }

    private static SubstanceTheme getDisabledTheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_GRAY;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_METALLIC;
        }
        if (themeKind == ThemeKind.NEGATED) {
            return NEGATED_METALLIC;
        }
        return LIGHT_GRAY;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static SubstanceTheme getTheme(String displayName) {
        ThemeInfo themeInfo = SubstanceLookAndFeel.getAllThemes().get(displayName);
        if (themeInfo != null) {
            return SubstanceTheme.createInstance(themeInfo);
        }
        throw new IllegalStateException("Theme with display name '" + displayName + "' can not be found");
    }

    public ColorScheme getDefaultColorScheme() {
        return this.getDefaultTheme().getColorScheme();
    }

    public ColorScheme getDisabledColorScheme() {
        return this.getDisabledTheme().getColorScheme();
    }

    public SubstanceTheme getTheme(Component comp, ComponentState componentState) {
        if (componentState.isKindActive(FadeKind.PRESS)) {
            if (this.pressedTheme == null) {
                this.pressedTheme = this.getActiveTheme().shade(0.2).saturate(0.1);
            }
            return this.pressedTheme;
        }
        switch (componentState.getColorSchemeKind()) {
            case CURRENT: {
                return this.getActiveTheme();
            }
            case REGULAR: {
                return this.getDefaultTheme();
            }
            case DISABLED: {
                return this.getDisabledTheme();
            }
        }
        return this;
    }

    public SubstanceTheme getHighlightTheme(Component comp, ComponentState componentState) {
        switch (componentState.getColorSchemeKind()) {
            case CURRENT: {
                return this.getActiveTheme();
            }
            case REGULAR: {
                return this.getDefaultTheme();
            }
            case DISABLED: {
                return this.getDisabledTheme();
            }
        }
        return this;
    }

    public float getHighlightThemeAlpha(Component comp, ComponentState componentState) {
        boolean isRollover = componentState.isKindActive(FadeKind.ROLLOVER);
        boolean isSelected = componentState.isKindActive(FadeKind.SELECTION);
        boolean isArmed = componentState.isKindActive(FadeKind.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public float getThemeAlpha(Component comp, ComponentState componentState) {
        return 1.0f;
    }

    public SubstanceTheme getActiveTheme() {
        return this;
    }

    public SubstanceTheme getDefaultTheme() {
        return SubstanceTheme.getDefaultTheme(this.kind);
    }

    public SubstanceTheme getDisabledTheme() {
        return SubstanceTheme.getDisabledTheme(this.kind);
    }

    @Deprecated
    public boolean isDark() {
        return SubstanceCoreUtilities.isThemeDark(this);
    }

    @Deprecated
    public static SubstanceTheme addUserDefined(ColorScheme scheme, ThemeKind themeKind, String displayName) {
        SubstanceTheme userTheme = new SubstanceTheme(scheme, displayName, themeKind);
        return userTheme;
    }

    public Color getWatermarkStampColor() {
        return SubstanceCoreUtilities.isThemeDark(this) ? SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getUltraLightColor(), 30) : SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getMidColor(), 50);
    }

    public static SubstanceTheme createInstance(ThemeInfo themeInfo) {
        ThemeKind themeKind = themeInfo.getThemeKind();
        if (themeKind == ThemeKind.MIXED) {
            try {
                MixedThemeInfo mixedThemeInfo = (MixedThemeInfo)themeInfo;
                String[] themeClassNames = mixedThemeInfo.getThemeClassNames();
                SubstanceTheme[] themeInstances = new SubstanceTheme[themeClassNames.length];
                for (int i = 0; i < themeClassNames.length; ++i) {
                    Class<?> themeClass = Class.forName(themeClassNames[i]);
                    if (themeClass == null) {
                        return null;
                    }
                    Object obj = themeClass.newInstance();
                    if (obj == null) {
                        return null;
                    }
                    if (!(obj instanceof SubstanceTheme)) {
                        return null;
                    }
                    themeInstances[i] = (SubstanceTheme)obj;
                }
                SubstanceMixTheme mixedTheme = new SubstanceMixTheme(themeInstances);
                return mixedTheme;
            }
            catch (Exception exc) {
                return null;
            }
        }
        if (themeKind == ThemeKind.INVERTED) {
            try {
                Class<?> themeClass = Class.forName(themeInfo.getClassName());
                if (themeClass == null) {
                    return null;
                }
                Object obj = themeClass.newInstance();
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof SubstanceTheme)) {
                    return null;
                }
                SubstanceTheme origTheme = (SubstanceTheme)obj;
                SubstanceInvertedTheme invertedTheme = new SubstanceInvertedTheme(origTheme);
                return invertedTheme;
            }
            catch (Exception exc) {
                return null;
            }
        }
        if (themeKind == ThemeKind.NEGATED) {
            try {
                Class<?> themeClass = Class.forName(themeInfo.getClassName());
                if (themeClass == null) {
                    return null;
                }
                Object obj = themeClass.newInstance();
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof SubstanceTheme)) {
                    return null;
                }
                SubstanceTheme origTheme = (SubstanceTheme)obj;
                SubstanceNegatedTheme negatedTheme = new SubstanceNegatedTheme(origTheme);
                return negatedTheme;
            }
            catch (Exception exc) {
                return null;
            }
        }
        try {
            Class<?> themeClass = Class.forName(themeInfo.getClassName());
            if (themeClass == null) {
                return null;
            }
            Object obj = themeClass.newInstance();
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof SubstanceTheme)) {
                return null;
            }
            return (SubstanceTheme)obj;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public SubstanceTheme tint(double tintFactor) {
        return new SubstanceTintTheme(this, tintFactor);
    }

    public SubstanceTheme tone(double toneFactor) {
        return new SubstanceToneTheme(this, toneFactor);
    }

    public SubstanceTheme shade(double shadeFactor) {
        return new SubstanceShadeTheme(this, shadeFactor);
    }

    public SubstanceTheme saturate(double saturateFactor) {
        return this.saturate(saturateFactor, true);
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        return new SubstanceSaturatedTheme(this, saturateFactor, toSaturateEverything);
    }

    public SubstanceTheme invert() {
        return new SubstanceInvertedTheme(this);
    }

    public SubstanceTheme negate() {
        return new SubstanceNegatedTheme(this);
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        return new SubstanceHueShiftTheme(this, hueShiftFactor);
    }

    public SubstanceTheme protanopia() {
        return new SubstanceProtanopiaTheme(this);
    }

    public SubstanceTheme tritanopia() {
        return new SubstanceTritanopiaTheme(this);
    }

    public SubstanceTheme deuteranopia() {
        return new SubstanceDeuteranopiaTheme(this);
    }

    public SubstanceTheme getActiveTitlePaneTheme() {
        return this;
    }

    public SubstanceTheme getDefaultTitlePaneTheme() {
        return this;
    }

    public SubstanceTheme getFirstTheme() {
        return this;
    }

    public SubstanceTheme getSecondTheme() {
        return this;
    }

    public SubstanceTheme getWatermarkTheme() {
        if (SubstanceCoreUtilities.isThemeDark(this)) {
            return this.getActiveTheme();
        }
        return this.getDefaultTheme();
    }

    public SubstanceTheme getBorderTheme() {
        return this;
    }

    public SubstanceGradientPainter getNonActivePainter() {
        return new StandardGradientPainter();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public double getSelectedTabFadeStart() {
        return 0.1;
    }

    public double getSelectedTabFadeEnd() {
        return 0.3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThemeKind {
        BRIGHT,
        COLD,
        DARK,
        INVERTED,
        MIXED,
        NEGATED;

    }
}

