/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl;

import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.core.impl.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.SynchronizeFault;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformationTypeType;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class CoreManagerImplTest {
    private static ESBFactory factory = new ESBFactoryImpl();
    private AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");

    private Node createNode(QName name, boolean explorer, String host, int port, int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl(explorer, host, port, new ExternalServer[]{new SoapServer(new SoapServerConfig(soap_port))}));
        return node;
    }

    public Node createESBEnvironment() throws ESBException, AdminExceptionMsg, InterruptedException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), false, "localhost", 9010, 8095);
        Thread.sleep(1000L);
        System.out.println("Server ready...");
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionWithESB() throws ESBException, AdminExceptionMsg, TransportException, GovException, InterruptedException, ConnectToEnvironmentFault {
        Node node = null;
        try {
            CoreManagerImpl.getInstance().setConfiguration((com.petalslink.easiergov.core.config.Configuration)new ConfigurationImpl());
            node = this.createESBEnvironment();
            ResourcesManagerImpl.getInstance().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = CoreManagerImpl.getInstance().getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)"{http://com.ebmwebsourcing.easyesb}node0", (Object)response.getExecutionEnvironmentInformation().getName());
            Assert.assertEquals((Object)EJaxbExecutionEnvironmentInformationTypeType.ESB, (Object)response.getExecutionEnvironmentInformation().getType());
            Assert.assertEquals((Object)"1.0-SNAPSHOT", (Object)response.getExecutionEnvironmentInformation().getVersion());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            CoreManagerImpl.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronize_WithNoEndpoint() throws ESBException, AdminExceptionMsg, TransportException, GovException, InterruptedException, ConnectToEnvironmentFault, SynchronizeFault {
        Node node = null;
        try {
            CoreManagerImpl.getInstance().setConfiguration((com.petalslink.easiergov.core.config.Configuration)new ConfigurationImpl());
            node = this.createESBEnvironment();
            ResourcesManagerImpl.getInstance().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = CoreManagerImpl.getInstance().getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response);
            CoreManagerImpl.getInstance().getConnexionManager().synchronize();
            Assert.assertEquals((long)0L, (long)ResourcesManagerImpl.getInstance().getNumberOfResources());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            CoreManagerImpl.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronize_With1Endpoint() throws ESBException, AdminExceptionMsg, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault {
        Node node = null;
        try {
            CoreManagerImpl.getInstance().setConfiguration((com.petalslink.easiergov.core.config.Configuration)new ConfigurationImpl());
            node = this.createESBEnvironment();
            ResourcesManagerImpl.getInstance().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
            String consumerSoapAddress = this.client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
            Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = CoreManagerImpl.getInstance().getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response);
            CoreManagerImpl.getInstance().getConnexionManager().synchronize();
            while (ResourcesManagerImpl.getInstance().getNumberOfResources() == 0) {
                Thread.sleep(200L);
                System.out.println("Wait!!!");
            }
            System.out.println(ResourcesManagerImpl.getInstance());
            Assert.assertEquals((long)3L, (long)ResourcesManagerImpl.getInstance().getNumberOfResources());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            CoreManagerImpl.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronize_With1Endpoint_UsingSubscription() throws ESBException, AdminExceptionMsg, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault {
        Node node = null;
        try {
            CoreManagerImpl.getInstance().setConfiguration((com.petalslink.easiergov.core.config.Configuration)new ConfigurationImpl());
            node = this.createESBEnvironment();
            ResourcesManagerImpl.getInstance().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = CoreManagerImpl.getInstance().getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response);
            CoreManagerImpl.getInstance().getConnexionManager().synchronize();
            String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
            String consumerSoapAddress = this.client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
            Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            while (ResourcesManagerImpl.getInstance().getNumberOfResources() == 0 && end - start < 20000L) {
                Thread.sleep(200L);
                end = System.currentTimeMillis();
            }
            System.out.println(ResourcesManagerImpl.getInstance());
            Assert.assertEquals((long)3L, (long)ResourcesManagerImpl.getInstance().getNumberOfResources());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            CoreManagerImpl.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronize_UsecaseCrisis_UsingSubscription() throws ESBException, AdminExceptionMsg, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault {
        Node node = null;
        try {
            CoreManagerImpl.getInstance().setConfiguration((com.petalslink.easiergov.core.config.Configuration)new ConfigurationImpl());
            node = this.createESBEnvironment();
            ResourcesManagerImpl.getInstance().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = CoreManagerImpl.getInstance().getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response);
            CoreManagerImpl.getInstance().getConnexionManager().synchronize();
            List endpointExposed = this.client.storeBpel(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/confinment_macro/confinment_macro.bpel").toExternalForm());
            endpointExposed = this.client.storeBpel(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/deliver_iodine.bpel").toExternalForm());
            System.out.println("DEBUT");
            while (ResourcesManagerImpl.getInstance().getNumberOfResources() < 24) {
                Thread.sleep(1000L);
                System.out.println("****************************************************************** J ATTENDS: ResourcesManagerImpl.getInstance().getNumberOfResources()  = " + ResourcesManagerImpl.getInstance().getNumberOfResources());
            }
            System.out.println("Storage :\n" + ResourcesManagerImpl.getInstance());
            Assert.assertTrue((ResourcesManagerImpl.getInstance().getNumberOfResources() >= 24 ? 1 : 0) != 0);
        }
        finally {
            if (node != null) {
                node.stop();
            }
            CoreManagerImpl.getInstance().clear();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

