/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.data;

import com.petalslink.data_api._1.FindComplexTypes;
import com.petalslink.data_api._1.FindComplexTypesResponse;
import com.petalslink.data_api._1.FindElements;
import com.petalslink.data_api._1.FindElementsResponse;
import com.petalslink.data_api._1.FindSimpleTypes;
import com.petalslink.data_api._1.FindSimpleTypesResponse;
import com.petalslink.data_api._1.GetComplexType;
import com.petalslink.data_api._1.GetComplexTypeResponse;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import com.petalslink.data_api._1.GetSimpleType;
import com.petalslink.data_api._1.GetSimpleTypeResponse;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.data_api._1.PublishSchemaFromURLResponse;
import com.petalslink.data_api._1_0.DataManager;
import com.petalslink.data_api._1_0.FaultMessage;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.data.DataManagerImpl;
import com.petalslink.easiergov.data.SchemaResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.resources_api._1_0.ResourcesManager;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataImplTest {
    private DataManager servicesAPI = null;
    private ResourcesManagerImpl resourcesManager = null;

    @Before
    public void setup() throws GovException {
        this.resourcesManager = new ResourcesManagerImpl((Configuration)new ConfigurationImpl());
        this.servicesAPI = new DataManagerImpl((ResourcesManager)this.resourcesManager);
    }

    public List<EJaxbResourceIdentifier> publishSchemaFromURL(URL url) throws FaultMessage {
        PublishSchemaFromURL request = new PublishSchemaFromURL();
        request.setXsdUrl(url.toString());
        PublishSchemaFromURLResponse response = this.servicesAPI.publishSchemaFromURL(request);
        return response.getResourceIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishSchema() throws FaultMessage, GovException {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertEquals((long)9L, (long)id.size());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetElement() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            GetElement request = new GetElement();
            request.setIdElement(QName.valueOf(id.get(0).getId()));
            GetElementResponse response = this.servicesAPI.getElement(request);
            Assert.assertNotNull((Object)response);
            System.out.println("element.getName() = " + response.getAny());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetComplexType() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            GetComplexType request = new GetComplexType();
            request.setIdComplexType(new QName("http://www.example.org/firemen/", "myCT"));
            GetComplexTypeResponse response = this.servicesAPI.getComplexType(request);
            Assert.assertNotNull((Object)response);
            System.out.println("ct.getName() = " + response.getAny());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSimpleType() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            GetSimpleType request = new GetSimpleType();
            request.setIdSimpleType(new QName("http://www.example.org/firemen/", "myST"));
            GetSimpleTypeResponse response = this.servicesAPI.getSimpleType(request);
            Assert.assertNotNull((Object)response);
            System.out.println("st.getName() = " + response.getAny());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindElements() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            FindElements request = new FindElements();
            request.setQuery(QName.valueOf(id.get(0).getId()).getLocalPart());
            FindElementsResponse response = this.servicesAPI.findElements(request);
            Assert.assertNotNull((Object)response);
            System.out.println("element.getName() = " + response.getAny());
            Assert.assertEquals((long)1L, (long)response.getAny().size());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindComplexTypes() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            FindComplexTypes request = new FindComplexTypes();
            request.setQuery("myCT");
            FindComplexTypesResponse response = this.servicesAPI.findComplexTypes(request);
            Assert.assertNotNull((Object)response);
            System.out.println("ct.getName() = " + response.getAny());
            Assert.assertEquals((long)1L, (long)response.getAny().size());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindSimpleTypes() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new SchemaResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishSchemaFromURL(Thread.currentThread().getContextClassLoader().getResource("firemen.xsd"));
            FindSimpleTypes request = new FindSimpleTypes();
            request.setQuery("myST");
            FindSimpleTypesResponse response = this.servicesAPI.findSimpleTypes(request);
            Assert.assertNotNull((Object)response);
            System.out.println("st.getName() = " + response.getAny());
            Assert.assertEquals((long)1L, (long)response.getAny().size());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

