/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.execution_environment_connection;

import com.petalslink.easiergov.execution_environment_connection.ExecutionEnvironmentConnectionClientImpl;
import com.petalslink.easiergov.execution_environment_connection.util.SOAJAXBContext;
import com.petalslink.easiergov.execution_environment_connection.util.SOAUtil;
import com.petalslink.easiergov.execution_environment_connection.util.provider.ExecutionEnvironmentManager_ExecutionEnvironmentManagerPort_Server;
import com.petalslink.easiergov.execution_environment_connection_api._1.ExecutionEnvironmentInformationType;
import com.petalslink.easiergov.execution_environment_connection_api._1.GetEndpointsResponse;
import com.petalslink.easiergov.execution_environment_connection_api._1.GetExecutionEnvironmentInformationResponse;
import java.io.InputStream;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ConnectionTest {
    ExecutionEnvironmentManager_ExecutionEnvironmentManagerPort_Server wsmock = null;
    ExecutionEnvironmentConnectionClientImpl client = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEndpointsMethod() throws Exception {
        try {
            Document doc = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResourceAsStream("dataset/getEndpointsResponse/dataset-2ep.xml"));
            SOAJAXBContext.getInstance();
            GetEndpointsResponse datasetEp = (GetEndpointsResponse)SOAJAXBContext.marshallAnyType((Document)doc, GetEndpointsResponse.class);
            this.wsmock = new ExecutionEnvironmentManager_ExecutionEnvironmentManagerPort_Server("http://localhost:8900/easiergov/ExecutionEnvironmentManagerService", datasetEp);
            this.client = new ExecutionEnvironmentConnectionClientImpl("http://localhost:8900/easiergov/ExecutionEnvironmentManagerService");
            List epts = this.client.getEndpoints();
            Assert.assertEquals((int)2, (int)epts.size());
        }
        finally {
            if (this.wsmock != null) {
                this.wsmock.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetExecutionEnvironmentInformationMethod() throws Exception {
        try {
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("dataset/getExecutionEnvironmentInformationResponse/dataset-2info.xml");
            if (input != null) {
                Document doc = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(input);
                SOAJAXBContext.getInstance();
                GetExecutionEnvironmentInformationResponse expectedDatasetInfo = (GetExecutionEnvironmentInformationResponse)SOAJAXBContext.marshallAnyType((Document)doc, GetExecutionEnvironmentInformationResponse.class);
                this.wsmock = new ExecutionEnvironmentManager_ExecutionEnvironmentManagerPort_Server("http://localhost:8900/easiergov/ExecutionEnvironmentManagerService", expectedDatasetInfo);
                this.client = new ExecutionEnvironmentConnectionClientImpl("http://localhost:8900/easiergov/ExecutionEnvironmentManagerService");
                ExecutionEnvironmentInformationType currentDatasetInfo = this.client.getExecutionEnvironmentInformation();
                System.out.println(currentDatasetInfo.getName());
                System.out.println(currentDatasetInfo.getVersion());
                System.out.println(currentDatasetInfo.getType());
                Assert.assertEquals((String)expectedDatasetInfo.getExecutionEnvironmentInformation().getName(), (String)currentDatasetInfo.getName());
                Assert.assertEquals((String)expectedDatasetInfo.getExecutionEnvironmentInformation().getVersion(), (String)currentDatasetInfo.getVersion());
                Assert.assertEquals((Object)expectedDatasetInfo.getExecutionEnvironmentInformation().getType(), (Object)currentDatasetInfo.getType());
            }
        }
        finally {
            if (this.wsmock != null) {
                this.wsmock.stop();
            }
        }
    }
}

