/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.launcher.tasks;

import com.ebmwebsourcing.easiergov.ServerImplementation;
import com.ebmwebsourcing.easiergov.launcher.tasks.Task;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.core.container.Server;
import java.util.List;

public class InfoTask
extends Task {
    private Container node = null;

    public InfoTask(Container node) {
        this.node = node;
        this.setShortcut("i");
        this.setName("info");
        this.setDescription("Display the local container information");
    }

    @Override
    public int doProcess(List<String> args) {
        block5: {
            try {
                System.out.println("Infos:\n");
                if (this.node != null) {
                    System.out.println("\tList of services deployed:");
                    for (Server s : this.node.getServers()) {
                        System.out.println("\t\t" + s.getName() + " at " + s.getAddress());
                    }
                    System.out.println("\n\n");
                    for (Server s : this.node.getServers()) {
                        if (!(s.getImplementation() instanceof ServerImplementation)) continue;
                        ((ServerImplementation)s.getImplementation()).getInfo();
                    }
                    break block5;
                }
                throw new GovException("node cannot be null");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return 1;
    }
}

