/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl;

import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.test.util.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.SynchronizeFault;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformationTypeType;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoreManagerImplTest {
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);
    private AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");
    private CoreManagerImpl coreManager = null;
    private Node node = null;

    @Before
    public void setup() throws GovException, ESBException {
        this.coreManager = new CoreManagerImpl((com.petalslink.easiergov.config.Configuration)new com.petalslink.easiergov.config.ConfigurationImpl());
        this.node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
    }

    @After
    public void tearDown() throws GovException, TransportException {
        if (this.node != null) {
            this.node.stop();
        }
        this.coreManager.clear();
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    @Test
    public void testConnectionWithESB() throws ESBException, TransportException, GovException, InterruptedException, ConnectToEnvironmentFault {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        ConnectToEnvironment request = new ConnectToEnvironment();
        request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
        ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"{http://com.ebmwebsourcing.easyesb}node0", (Object)response.getExecutionEnvironmentInformation().getName());
        Assert.assertEquals((Object)EJaxbExecutionEnvironmentInformationTypeType.ESB, (Object)response.getExecutionEnvironmentInformation().getType());
        Assert.assertEquals((Object)"1.0-SNAPSHOT", (Object)response.getExecutionEnvironmentInformation().getVersion());
    }

    @Test
    public void testSynchronize_WithNoEndpoint() throws ESBException, TransportException, GovException, InterruptedException, ConnectToEnvironmentFault, SynchronizeFault {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        ConnectToEnvironment request = new ConnectToEnvironment();
        request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
        ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
        Assert.assertNotNull((Object)response);
        this.coreManager.getConnexionManager().synchronize();
        Assert.assertEquals((long)0L, (long)this.coreManager.getResourcesManager().getNumberOfResources());
    }

    @Test
    public void testSynchronize_With1Endpoint() throws ESBException, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault, ManagementException {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
        String consumerSoapAddress = this.client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
        Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
        ConnectToEnvironment request = new ConnectToEnvironment();
        request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
        ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
        Assert.assertNotNull((Object)response);
        this.coreManager.getConnexionManager().synchronize();
        while (this.coreManager.getResourcesManager().getNumberOfResources() == 0) {
            Thread.sleep(200L);
            System.out.println("Wait!!!");
        }
        System.out.println(this.coreManager.getResourcesManager());
        Assert.assertEquals((long)3L, (long)this.coreManager.getResourcesManager().getNumberOfResources());
    }

    @Test
    public void testSynchronize_With1Endpoint_UsingSubscription() throws ESBException, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault, ManagementException {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        ConnectToEnvironment request = new ConnectToEnvironment();
        request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
        ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
        Assert.assertNotNull((Object)response);
        this.coreManager.getConnexionManager().synchronize();
        String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
        String consumerSoapAddress = this.client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
        Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        while (this.coreManager.getResourcesManager().getNumberOfResources() == 0 && end - start < 20000L) {
            Thread.sleep(200L);
            end = System.currentTimeMillis();
        }
        System.out.println(this.coreManager.getResourcesManager());
        Assert.assertEquals((long)3L, (long)this.coreManager.getResourcesManager().getNumberOfResources());
    }

    @Test
    public void testSynchronize_UsecaseCrisis_UsingSubscription() throws ESBException, TransportException, InterruptedException, GovException, ConnectToEnvironmentFault, SynchronizeFault, ManagementException {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        ConnectToEnvironment request = new ConnectToEnvironment();
        request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
        ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
        Assert.assertNotNull((Object)response);
        this.coreManager.getConnexionManager().synchronize();
        EJaxbDeployementReport endpointExposed = this.client.deploy(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/confinment_macro/confinment_macro.bpel"));
        endpointExposed = this.client.deploy(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/deliver_iodine.bpel"));
        System.out.println("DEBUT");
        while (this.coreManager.getResourcesManager().getNumberOfResources() < 11) {
            Thread.sleep(1000L);
            System.out.println("****************************************************************** J ATTENDS: ResourcesManagerImpl.getInstance().getNumberOfResources()  = " + this.coreManager.getResourcesManager().getNumberOfResources());
        }
        System.out.println("Storage :\n" + this.coreManager.getResourcesManager());
        Assert.assertTrue((this.coreManager.getResourcesManager().getNumberOfResources() >= 11 ? 1 : 0) != 0);
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

