/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.sla;

import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectNodeImpl;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.sla.AgreementTemplateResourceType;
import com.petalslink.easiergov.sla.SlaResourceType;
import com.petalslink.resources_api._1.Get;
import com.petalslink.resources_api._1.GetResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1_0.GetFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import com.petalslink.sla_api._1.Fault;
import com.petalslink.sla_api._1.PublishTemplateFromDocument;
import com.petalslink.sla_api._1.PublishTemplateFromDocumentResponse;
import com.petalslink.sla_api._1.PublishTemplateFromURL;
import com.petalslink.sla_api._1.PublishTemplateFromURLResponse;
import com.petalslink.sla_api._1.ResourceIdentifier;
import com.petalslink.sla_api._1_0.FaultMessage;
import com.petalslink.sla_api._1_0.SlaManager;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementTemplateType;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import easybox.org.w3._2005._08.addressing.ObjectFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="SlaManager", portName="SlaManagerPort", targetNamespace="http://www.petalslink.com/sla-api/1.0", wsdlLocation="sla-ws.wsdl", endpointInterface="com.petalslink.sla_api._1_0.SlaManager")
public class SlaManagerImpl
implements SlaManager {
    private static Logger LOG = Logger.getLogger(SlaManagerImpl.class.getName());
    private ResourcesManager resourceManager;

    public SlaManagerImpl(ResourcesManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public EJaxbAgreementTemplateType getTemplate(QName idTemplate) throws FaultMessage {
        EJaxbAgreementTemplateType response = null;
        LOG.fine("Call getTemplate method");
        Resource resp = ((ResourcesManagerImpl)this.resourceManager).get(idTemplate, (ResourceType)SlaResourceType.getInstance());
        if (resp == null) {
            String errorMsg = "Impossible to find template corresponding to this id: " + idTemplate;
            Fault f = new Fault();
            f.setMessage(errorMsg);
            FaultMessage faultError = new FaultMessage(errorMsg, f);
            throw faultError;
        }
        response = (EJaxbAgreementTemplateType)((AbstractXmlObjectNodeImpl)resp.getContent()).getModelObject();
        return response;
    }

    public List<EJaxbAgreementTemplateType> findTemplatesByService(QName parameters) {
        ArrayList<EJaxbAgreementTemplateType> agreements = new ArrayList<EJaxbAgreementTemplateType>();
        List resources = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType((ResourceType)AgreementTemplateResourceType.getInstance());
        try {
            for (Resource res : resources) {
                EJaxbAgreementTemplateType con = (EJaxbAgreementTemplateType)res.getContent();
                EJaxbEndpointReferenceType edref = null;
                if (con.getContext().getAgreementResponder() instanceof EJaxbEndpointReferenceType) {
                    edref = (EJaxbEndpointReferenceType)con.getContext().getAgreementResponder();
                } else if (con.getContext().getAgreementResponder() instanceof Element) {
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.adoptNode((Element)con.getContext().getAgreementResponder()));
                    edref = (EJaxbEndpointReferenceType)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbEndpointReferenceType.class);
                }
                URI uri = URI.create(edref.getAddress().getValue());
                EndpointAddress edpAd = null;
                edpAd = ESBUtil.analyzeURI((URI)uri);
                QName qnameservice = new QName(edpAd.getNamespace(), edpAd.getServicename());
                if (!qnameservice.equals(parameters)) continue;
                resources.add(res);
                agreements.add((EJaxbAgreementTemplateType)res.getContent());
            }
        }
        catch (Exception ex) {
            Fault fault = new Fault();
            fault.setMessage(ex.getMessage());
            Fault f = new Fault();
        }
        return agreements;
    }

    public PublishTemplateFromURLResponse publishTemplateFromURL(PublishTemplateFromURL parameters) throws FaultMessage {
        PublishTemplateFromURLResponse res = new PublishTemplateFromURLResponse();
        try {
            Publish request = new Publish();
            request.setRessourceUrl(parameters.getURL());
            PublishResponse response = this.resourceManager.publish(request);
            if (response != null) {
                for (com.petalslink.resources_api._1.ResourceIdentifier rid : response.getResourceIdentifier()) {
                    ResourceIdentifier rids = new ResourceIdentifier();
                    rids.setId(QName.valueOf(rid.getId()));
                    rids.setResourceType(rid.getResourceType());
                    res.getResourceIdentifier().add(rids);
                }
            }
        }
        catch (PublishFault e) {
            Fault fault = new Fault();
            fault.setMessage(e.getMessage());
            Fault f = new Fault();
        }
        return res;
    }

    public PublishTemplateFromDocumentResponse publishTemplateFromDocument(PublishTemplateFromDocument parameters) throws FaultMessage {
        PublishTemplateFromDocumentResponse res;
        block7: {
            EndpointReferenceType idService = (EndpointReferenceType)parameters.getWsagreement().getContext().getAgreementResponder();
            URI uriService = idService.getAddress().getValue();
            EndpointAddress edpAd = null;
            res = null;
            try {
                edpAd = ESBUtil.analyzeURI((URI)uriService);
                QName qnameservice = new QName(edpAd.getNamespace() + edpAd.getServicename());
                Get request = new Get();
                request.setId(qnameservice);
                GetResponse gresponse = null;
                gresponse = this.resourceManager.get(request);
                if (gresponse.getAny() != null) {
                    res = new PublishTemplateFromDocumentResponse();
                    Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)parameters);
                    PublishResponse response = ((ResourcesManagerImpl)this.resourceManager).publish(doc, null);
                    if (response != null) {
                        for (com.petalslink.resources_api._1.ResourceIdentifier rid : response.getResourceIdentifier()) {
                            ResourceIdentifier rids = new ResourceIdentifier();
                            rids.setId(QName.valueOf(rid.getId()));
                            rids.setResourceType(rid.getResourceType());
                            res.getResourceIdentifier().add(rids);
                        }
                    }
                    break block7;
                }
                FaultMessage faultError = new FaultMessage("Impossible to find service corresponding to this id: " + uriService);
                throw faultError;
            }
            catch (PublishFault e) {
                Fault fault = new Fault();
                fault.setMessage(e.getMessage());
                Fault f = new Fault();
            }
            catch (SOAException e) {
                Fault fault = new Fault();
                fault.setMessage(e.getMessage());
                Fault f = new Fault();
            }
            catch (GetFault e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

