/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.cli.impl;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.Arrays;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiergov.cli.impl.GOVCommandManager;
import com.ebmwebsourcing.easiergov.cli.impl.command.ConnectToEnvironmentCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.GOVConnectCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.GOVScriptCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.cli.impl.ESBClientLauncher;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.test.Echo_EchoSOAP_Server;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CommandsTest {
    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        });
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectToEnvironment() throws Exception {
        Node n = null;
        GOVConnectCommand cc = null;
        WSContainer container = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9000, 8100);
            String serviceAddress = "http://localhost:8100/services/adminExternalEndpoint";
            container = new WSContainer((com.petalslink.easiergov.config.Configuration)new com.petalslink.easiergov.config.ConfigurationImpl());
            container.start();
            GOVCommandManager cr = new GOVCommandManager();
            cc = new GOVConnectCommand((AbstractCommandManager)cr);
            cc.process(Arrays.asList((Object[])new String[]{"http://localhost:9600/services/connexionManager"}));
            Assert.assertEquals((int)1, (int)cc.getResultCode());
            ConnectToEnvironmentCommand impCommand = (ConnectToEnvironmentCommand)cr.findCommand("co");
            impCommand.process(Arrays.asList((Object[])new String[]{"http://localhost:8100/services/adminExternalEndpoint"}));
            Assert.assertEquals((int)1, (int)impCommand.getResultCode());
            System.out.println(impCommand.getResult());
            Assert.assertEquals((String)"Connect to {http://easyesb}testImportNode", (String)impCommand.getResult());
        }
        catch (ESBException e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (container != null) {
                container.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGovScript() throws Exception {
        Node n = null;
        GOVScriptCommand conf = null;
        WSContainer container = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9000, 8100);
            container = new WSContainer((com.petalslink.easiergov.config.Configuration)new com.petalslink.easiergov.config.ConfigurationImpl());
            container.start();
            GOVCommandManager cr = new GOVCommandManager();
            cr.init("http://localhost:9600/services/connexionManager");
            conf = (GOVScriptCommand)cr.findCommand("s");
            String arg = Thread.currentThread().getContextClassLoader().getResource("testConfScript.xml").getPath();
            conf.process(Arrays.asList((Object[])new String[]{arg}));
            Assert.assertEquals((int)1, (int)conf.getResultCode());
            System.out.println(conf.getResult());
            Assert.assertEquals((String)"Connect To Environment: Connect to {http://easyesb}testImportNode", (String)conf.getResult());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (container != null) {
                container.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testCLICommandOff() {
        Node n = null;
        Echo_EchoSOAP_Server echoServer = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9001, 8101);
            echoServer = new Echo_EchoSOAP_Server();
            String echoURL = "http://localhost:9001/echo";
            ESBClientLauncher launcher = new ESBClientLauncher((AbstractCommandManager)new GOVCommandManager());
            String[] args = new String[6];
            args[1] = "-c";
            args[2] = "http://localhost:8101/services/adminExternalEndpoint";
            args[3] = "-i";
            args[4] = "http://localhost:9001/echo";
            args[5] = "http://localhost:9001/echo?wsdl";
            launcher.launch(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (echoServer != null) {
                echoServer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCLICommandHelp() {
        Node n = null;
        Echo_EchoSOAP_Server echoServer = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9001, 8101);
            echoServer = new Echo_EchoSOAP_Server();
            String echoURL = "http://localhost:9001/echo";
            ESBClientLauncher launcher = new ESBClientLauncher((AbstractCommandManager)new GOVCommandManager());
            String[] args = new String[6];
            args[0] = "-h";
            args[1] = "-c";
            args[2] = "http://localhost:8101/services/adminExternalEndpoint";
            launcher.launch(args);
            System.out.println("ok");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (echoServer != null) {
                echoServer.shutdown();
            }
        }
    }
}

