/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.cli.impl.command;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import java.io.File;
import java.util.List;

public class PublishTopicNamespaceFromUrlCommand
extends AbstractCommand<EventManagerClientImplSOAP> {
    private String url;

    public PublishTopicNamespaceFromUrlCommand(EventManagerClientImplSOAP client) throws ESBException {
        super((Object)client);
        this.setName("PublishNamespaceFromUrl");
        this.setDescription("Publish Namespace From Url");
        this.setShortcut("pt");
    }

    public void execute() {
        try {
            PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
            if (this.url.startsWith(".")) {
                this.url = "file:///" + new File(this.url).getAbsolutePath();
            }
            request.setTopicNamespaceUrl(this.url);
            PublishTopicNamespaceFromURLResponse res = ((EventManagerClientImplSOAP)this.getClient()).publishTopicNamespaceFromURL(request);
            this.setResult("TopicNamespace is loaded: " + this.url);
            this.resultCode = 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    protected int doProcess(List<String> args) {
        this.url = args.get(0);
        this.execute();
        return this.resultCode;
    }

    protected boolean validateArgs(List<String> args) {
        return args.size() == 1;
    }

    public String toString() {
        return "pt <url> \t\t\t\t\t\t{Publish Namespace From Url}";
    }
}

