/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cep;

import com.ebmwebsourcing.cep.server.mock.MockEventCloud;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.launcher.tasks.InfoTask;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;

public class CepComponentTest {
    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testStartCEPComponentInNode() throws Exception {
        Assert.assertTrue((boolean)true);
        Node node = null;
        try {
            node = this.createNode(new QName("http://com.ebmwebsourcing", "esb"), "localhost", 9100, 8085);
            Assert.assertNotNull((Object)node);
            InfoTask i = new InfoTask(node);
            i.doProcess(null);
        }
        finally {
            if (node != null) {
                node.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployResourceOnCEPComponent() throws Exception {
        Assert.assertTrue((boolean)true);
        Node node = null;
        WSContainer easiergov = null;
        try {
            node = this.createNode(new QName("http://com.ebmwebsourcing", "esb"), "localhost", 9100, 8085);
            node.start();
            Assert.assertNotNull((Object)node);
            easiergov = new WSContainer((com.petalslink.easiergov.config.Configuration)new com.petalslink.easiergov.config.ConfigurationImpl("localhost", 9738, 9739));
            easiergov.start();
            DataManagerClientImplSOAP easierGovClient = new DataManagerClientImplSOAP("http://localhost:9738/services/dataManager");
            PublishSchemaFromURL publishRequest = new PublishSchemaFromURL();
            publishRequest.setXsdUrl(Thread.currentThread().getContextClassLoader().getResource("eventGlobal.xsd").toURI().toString());
            easierGovClient.publishSchemaFromURL(publishRequest);
            AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8085/services/adminExternalEndpoint");
            client.connectToGovernance("http://localhost:9738/services/adminManager");
            EJaxbDeployementReport report = client.deploy(new File("./src/test/resources/cepRules-example.cep").toURI().toURL());
            Assert.assertNotNull((Object)report);
        }
        finally {
            if (node != null) {
                node.stop();
            }
            if (easiergov != null) {
                easiergov.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivateRuleOnCEPComponent() throws Exception {
        Assert.assertTrue((boolean)true);
        Node node = null;
        WSContainer easiergov = null;
        try {
            MockEventCloud eventcloud = new MockEventCloud();
            NotificationConsumer_NotifierEndpoint_Server eventCloudServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)eventcloud, "http://localhost:9750/eventCloud");
            node = this.createNode(new QName("http://com.ebmwebsourcing", "esb"), "localhost", 9100, 8085);
            node.start();
            Assert.assertNotNull((Object)node);
            easiergov = new WSContainer((com.petalslink.easiergov.config.Configuration)new com.petalslink.easiergov.config.ConfigurationImpl("localhost", 9738, 9739));
            easiergov.start();
            DataManagerClientImplSOAP easierGovClient = new DataManagerClientImplSOAP("http://localhost:9738/services/dataManager");
            PublishSchemaFromURL publishRequest = new PublishSchemaFromURL();
            publishRequest.setXsdUrl(Thread.currentThread().getContextClassLoader().getResource("eventGlobal.xsd").toURI().toString());
            easierGovClient.publishSchemaFromURL(publishRequest);
            AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8085/services/adminExternalEndpoint");
            client.connectToGovernance("http://localhost:9738/services/adminManager");
            EJaxbDeployementReport report = client.deploy(new File("./src/test/resources/cepRules-example.cep").toURI().toURL());
            Assert.assertNotNull((Object)report);
            Subscribe subscribe = WSNHelper.createSubscription((String)"http://localhost:9750/eventCloud", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"), (QName[])new QName[]{new QName("http://www.mines-albi.fr/nuclearcrisisevent", "resourcesStatusEvent")});
            client.subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribe));
            String oe1msg = "      <ns27:offerEvent xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>e1372251-70c2-463b-820c-c5124072f635</ns27:uid>\r\n        <ns27:provider>bus</ns27:provider>\r\n        <ns27:resources>\r\n          <ns27:type>truck</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:offerEvent>";
            Document oe1 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(oe1msg.getBytes()));
            Notify notifyOe1 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)oe1);
            client.notify(WSNHelper.convert2JaxbElement((Notify)notifyOe1));
            String oe2msg = "      <ns27:offerEvent xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\">\r\n            <ns27:uid>aea63eba-795c-45ca-a57b-4f01c41736f1</ns27:uid>\r\n            <ns27:provider>car</ns27:provider>\r\n            <ns27:resources>\r\n              <ns27:type>driver</ns27:type>\r\n              <ns27:quantity>5.0</ns27:quantity>\r\n            </ns27:resources>\r\n          </ns27:offerEvent>";
            Document oe2 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(oe2msg.getBytes()));
            Notify notifyOe2 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)oe2);
            client.notify(WSNHelper.convert2JaxbElement((Notify)notifyOe2));
            String de2msg = "      <ns27:demandEvent xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>3bef76d3-9dd1-4c43-a250-47e671ad9844</ns27:uid>\r\n        <ns27:resources>\r\n          <ns27:type>driver</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:demandEvent>";
            Document de2 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(de2msg.getBytes()));
            Notify notifyDe2 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)de2);
            client.notify(WSNHelper.convert2JaxbElement((Notify)notifyDe2));
            String de1msg = "      <ns27:demandEvent xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>3bef76d3-9dd1-4c43-a250-47e671ad9844</ns27:uid>\r\n        <ns27:resources>\r\n          <ns27:type>truck</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:demandEvent>";
            Document de1 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(de1msg.getBytes()));
            Notify notifyDe1 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)de1);
            client.notify(WSNHelper.convert2JaxbElement((Notify)notifyDe1));
            while (eventcloud.getCptNotification() < 6) {
                System.out.println("notifs ........... : " + eventcloud.getCptNotification());
                Thread.sleep(1000L);
            }
            Assert.assertEquals((long)6L, (long)eventcloud.getCptNotification());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            if (easiergov != null) {
                easiergov.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (Exception ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

