/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cep;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.cep.EventListener;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.UpdateListener;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import easyesb.ebmwebsourcing.com.data.ceprules.EJaxbCepRule;
import easyesb.ebmwebsourcing.com.data.ceprules.EJaxbCepRules;
import easyesb.ebmwebsourcing.com.data.ceprules.EJaxbSubscriptionsRequired;
import easyesb.ebmwebsourcing.com.data.ceprules.ObjectFactory;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AdminProxyEventManager;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CepComponentBehaviourImpl
extends AbstractComponentBehaviourImpl
implements ComponentBehaviour,
NotificationConsumer {
    private final Logger log = Logger.getLogger(CepComponentBehaviourImpl.class.getName());
    private static int cpt;
    private DataManagerClientImplSOAP easierGovClient;
    private EPServiceProvider epService = null;

    public CepComponentBehaviourImpl(Component<? extends ComponentType> ep) throws ESBException {
        super(ep);
    }

    public void execute(Exchange exchange) throws TransportException {
        super.execute(exchange);
        try {
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify") && exchange.getMessageIn().getBody().getPayload() instanceof Document) {
                this.log.finest("NOTIFY");
                EJaxbNotify notify = (EJaxbNotify)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbNotify.class);
                this.notify(notify);
                exchange.getMessageIn().getHeader().addProperty(MessageUtil.getInstance().createHeaderProperty(MessageUtil.EXCHANGE_ACCEPTED_BY_PROVIDER_PROPERTY, "true"));
            }
        }
        catch (Exception e) {
            this.log.severe("ERROR IN NOTIFICATION CONSUMER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy request) throws ManagementException {
        EJaxbDeployResponse response = new EJaxbDeployResponse();
        try {
            response.setDeployementReport(new EJaxbDeployementReport());
            String cepURL = request.getMainResource().getFileURI();
            if (request.getMainResource().getAttachment() != null) {
                throw new ManagementException("Unsupported!!! Use deploy from URL instead");
            }
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new URL(cepURL).openStream());
            EJaxbCepRules rules = (EJaxbCepRules)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbCepRules.class);
            for (EJaxbCepRule rule : rules.getCepRule()) {
                this.createStatementFromRule(rule);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public DataManagerClientImplSOAP getEasierGovDataClient() {
        String governanceAddress;
        if (this.easierGovClient == null && (governanceAddress = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getGovernanceAddress()) != null) {
            String dataAddress = governanceAddress.substring(0, governanceAddress.lastIndexOf("/")) + "/dataManager";
            this.easierGovClient = new DataManagerClientImplSOAP(dataAddress);
        }
        return this.easierGovClient;
    }

    private void createStatementFromRule(EJaxbCepRule rule) throws ManagementException {
        List<EJaxbSubscriptionsRequired.Entry> entries = rule.getContext().getSubscriptionsRequired().getEntry();
        try {
            if (this.getEasierGovDataClient() == null) {
                throw new ManagementException("Impossible to connect to EasierGov");
            }
            for (EJaxbSubscriptionsRequired.Entry entry : entries) {
                if (entry.getCorrespondingEvent() == null) continue;
                GetElement request = new GetElement();
                request.setIdElement(entry.getCorrespondingEvent());
                GetElementResponse response = this.getEasierGovDataClient().getElement(request);
                String bufferSchema = null;
                if (response.getAny() instanceof EJaxbSchema) {
                    bufferSchema = XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny()));
                } else if (response.getAny() instanceof Element) {
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.adoptNode((Element)response.getAny()));
                    bufferSchema = XMLPrettyPrinter.prettyPrint((Document)doc);
                }
                String schemaText = XMLPrettyPrinter.prettyPrint((Document)DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(bufferSchema.getBytes())));
                this.log.finest("******** CEP number of subscription required: " + entries.size());
                ConfigurationEventTypeXMLDOM eventcfg = new ConfigurationEventTypeXMLDOM();
                eventcfg.setXPathPropertyExpr(true);
                this.log.finest("******** CEP entry.getCorrespondingEvent() = " + entry.getCorrespondingEvent());
                eventcfg.setRootElementName(entry.getCorrespondingEvent().getLocalPart());
                eventcfg.setSchemaText(schemaText);
                this.epService.getEPAdministrator().getConfiguration().addEventType(entry.getCorrespondingEvent().getLocalPart(), eventcfg);
            }
            EPStatement statement = this.epService.getEPAdministrator().createEPL(rule.getStatement());
            statement.addListener((UpdateListener)new EventListener(this.endpoint.getReference().toString(), rule.getAction(), this.getEasierGovDataClient()));
            this.log.finest("statement = " + statement);
            String adminExternalEndpointAddress = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getAdminExternalEndpoint();
            String clientAddress = this.endpoint.getReference().toString();
            for (EJaxbSubscriptionsRequired.Entry entry : entries) {
                try {
                    QName topicUsed = entry.getTopic();
                    this.log.finest("topicUsed: " + topicUsed);
                    Subscribe payload = WSNHelper.createSubscription((String)clientAddress, (QName)topicUsed, (QName[])new QName[]{entry.getCorrespondingEvent()});
                    Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
                    this.log.finest("CEP SUBSCRIBE on topic: " + topicUsed);
                    this.log.finest("CEP SUBSCRIBE :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                    String subscriptionAddress = entry.getEndpointAddressToSubscribe();
                    if (subscriptionAddress == null) {
                        subscriptionAddress = adminExternalEndpointAddress;
                    }
                    this.log.finest("CEP SUBSCRIBE ON " + topicUsed + " => OK");
                    EndpointAddress addr = new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), this.getEndpoint().getNode().getQName().getLocalPart() + "_admin"), "adminEndpoint", new QueryParam[0]);
                    URI adminRef = ESBUtil.generateURI((EndpointAddress)addr);
                    AdminEndpoint subscriber = (AdminEndpoint)((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(adminRef);
                    if (subscriber == null) {
                        throw new ESBException("Impossible to find administration of node : " + adminRef);
                    }
                    AdminProxyEventManager pem = ((BaseAdminEndpointBehaviour)subscriber.findBehaviour(BaseAdminEndpointBehaviour.class)).getProxyEventManager();
                    assert (pem != null);
                    pem.subscribe(WSNHelper.convert2JaxbElement((Subscribe)payload));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getSupportedResourcesExtensions() {
        return Arrays.asList("cep");
    }

    public void start() throws ESBException {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
        Configuration config = new Configuration();
        config.getEngineDefaults().getLogging().setEnableQueryPlan(true);
        config.getEngineDefaults().getLogging().setEnableExecutionDebug(true);
        config.getEngineDefaults().getLogging().setEnableTimerDebug(false);
        this.epService = EPServiceProviderManager.getDefaultProvider((Configuration)config);
    }

    public void stop() throws ESBException {
    }

    public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters) throws ManagementException {
        return null;
    }

    public void notify(EJaxbNotify notify) {
        this.log.info("Executing operation notify on cep");
        try {
            Document event = this.getEventInNotify(notify);
            this.log.finest("****** Notify on CEP: \n" + XMLPrettyPrinter.prettyPrint((Document)event));
            this.epService.getEPRuntime().sendEvent((Node)event);
            this.log.finest("****** NUMBER OF NOTIFICATION RECEIVED ON CEP: " + ++cpt);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private Document getEventInNotify(EJaxbNotify notify) throws WsnbException {
        Document doc = null;
        try {
            for (EJaxbNotificationMessageHolderType msgh : notify.getNotificationMessage()) {
                if (msgh.getMessage().getAny() instanceof Element) {
                    Element elmt = (Element)msgh.getMessage().getAny();
                    doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.adoptNode(elmt));
                    continue;
                }
                doc = SOAJAXBContext.getInstance().unmarshallAnyElement(msgh.getMessage().getAny());
            }
        }
        catch (Exception e) {
            throw new WsnbException((Throwable)e);
        }
        return doc;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        cpt = 0;
    }
}

